/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class BPartnerExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.parentsToExclude.add("C_Currency");
        this.parentsToExclude.add("AD_User_Roles");
        this.createBusinessPartners(ctx, document, this.parentsToExclude);
    }

    private void createBusinessPartners(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List bPartnerGroupList = new Query(ctx, "C_BP_Group", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (Object bPartnerGroup : bPartnerGroupList) {
            if (bPartnerGroup.getC_BP_Group_ID() < 999999) continue;
            this.cleanOfficialReference((PO)bPartnerGroup);
            this.packOut.createGenericPO(document, (PO)bPartnerGroup, true, parentsToExclude);
        }
        List paymentTermList = new Query(ctx, "C_PaymentTerm", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (Object paymentTerm : paymentTermList) {
            if (paymentTerm.getC_PaymentTerm_ID() < 999999) continue;
            this.cleanOfficialReference((PO)paymentTerm);
            this.packOut.createGenericPO(document, (PO)paymentTerm, true, parentsToExclude);
        }
        List bPartnerList = new Query(ctx, "C_BPartner", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MBPartner bPartner : bPartnerList) {
            if (bPartner.getC_BPartner_ID() < 999999) continue;
            this.cleanOfficialReference((PO)bPartner);
            this.packOut.createGenericPO(document, (PO)bPartner, true, parentsToExclude);
        }
        List bPartnerLocationList = new Query(ctx, "C_BPartner_Location", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (MBPartnerLocation bPartnerLocation : bPartnerLocationList) {
            if (bPartnerLocation.getC_BPartner_ID() < 999999) continue;
            List locationList = new Query(ctx, "C_Location", "C_Location_ID = ?", null).setOnlyActiveRecords(true).setParameters(new Object[]{bPartnerLocation.getC_Location_ID()}).list();
            for (MLocation location : locationList) {
                if (location.getC_Location_ID() < 999999) continue;
                this.cleanOfficialReference((PO)location);
                this.packOut.createGenericPO(document, (PO)location, true, parentsToExclude);
            }
            this.cleanOfficialReference((PO)bPartnerLocation);
            this.packOut.createGenericPO(document, (PO)bPartnerLocation, true, parentsToExclude);
        }
    }
}

