/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.exp;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.PackOut;
import org.compiere.model.MBrowseCustom;
import org.compiere.model.MBrowseFieldCustom;
import org.compiere.model.MFieldCustom;
import org.compiere.model.MProcessCustom;
import org.compiere.model.MProcessParaCustom;
import org.compiere.model.MTabCustom;
import org.compiere.model.MWindowCustom;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_ASP_Level;
import org.compiere.model.X_ASP_Module;
import org.spin.util.exp.ClientExporterHandler;
import org.xml.sax.SAXException;

public class ASPExporter
extends ClientExporterHandler {
    private List<String> parentsToExclude;
    private PackOut packOut;

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.packOut == null) {
            this.packOut = new PackOut();
            this.packOut.setLocalContext(ctx);
        }
        this.parentsToExclude = new ArrayList<String>();
        this.parentsToExclude.add("AD_User");
        this.parentsToExclude.add("AD_Role");
        this.parentsToExclude.add("AD_Window");
        this.parentsToExclude.add("AD_Tab");
        this.parentsToExclude.add("AD_Field");
        this.parentsToExclude.add("AD_Browse");
        this.parentsToExclude.add("AD_Browse_Field");
        this.parentsToExclude.add("AD_Process");
        this.parentsToExclude.add("AD_Process_Para");
        this.createASP(ctx, document, this.parentsToExclude);
    }

    private void createASP(Properties ctx, TransformerHandler document, List<String> parentsToExclude) throws SAXException {
        List aspList = new Query(ctx, "ASP_Module", null, null).setOnlyActiveRecords(true).setClient_ID().list();
        for (X_ASP_Module asp : aspList) {
            this.packOut.createGenericPO(document, (PO)asp, true, parentsToExclude);
            List levelList = new Query(ctx, "ASP_Level", "ASP_Module_ID = ?", null).setParameters(new Object[]{asp.getASP_Module_ID()}).setOnlyActiveRecords(true).list();
            for (X_ASP_Level level : levelList) {
                Object window2;
                this.packOut.createGenericPO(document, (PO)level, true, parentsToExclude);
                List windowCustomizationList = new Query(ctx, "AD_WindowCustom", "ASP_Level_ID = ?", null).setParameters(new Object[]{level.getASP_Level_ID()}).setOnlyActiveRecords(true).list();
                for (Object window2 : windowCustomizationList) {
                    this.createCustomWindow(ctx, document, (MWindowCustom)window2, parentsToExclude);
                }
                List processCustomizationList = new Query(ctx, "AD_ProcessCustom", "ASP_Level_ID = ?", null).setParameters(new Object[]{level.getASP_Level_ID()}).setOnlyActiveRecords(true).list();
                window2 = processCustomizationList.iterator();
                while (window2.hasNext()) {
                    MProcessCustom process = (MProcessCustom)window2.next();
                    this.createCustomProcess(ctx, document, process, parentsToExclude);
                }
                List browseCustomizationList = new Query(ctx, "AD_BrowseCustom", "ASP_Level_ID = ?", null).setParameters(new Object[]{level.getASP_Level_ID()}).setOnlyActiveRecords(true).list();
                for (MBrowseCustom browser : browseCustomizationList) {
                    this.createCustomBrowser(ctx, document, browser, parentsToExclude);
                }
            }
        }
    }

    private void createCustomWindow(Properties ctx, TransformerHandler document, MWindowCustom window, List<String> parentsToExclude) throws SAXException {
        this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
        this.packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
        this.packOut.createGenericPO(document, (PO)window, true, parentsToExclude);
        List tabList = new Query(ctx, "AD_TabCustom", "AD_WindowCustom_ID = ?", null).setParameters(new Object[]{window.getAD_WindowCustom_ID()}).setOnlyActiveRecords(true).list();
        for (MTabCustom tab : tabList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
            this.packOut.createGenericPO(document, (PO)tab, true, parentsToExclude);
            List fieldList = new Query(ctx, "AD_FieldCustom", "AD_TabCustom_ID = ?", null).setParameters(new Object[]{tab.getAD_TabCustom_ID()}).setOnlyActiveRecords(true).list();
            for (MFieldCustom field : fieldList) {
                this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
                this.packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
                this.packOut.createGenericPO(document, (PO)field, true, parentsToExclude);
            }
        }
    }

    private void createCustomProcess(Properties ctx, TransformerHandler document, MProcessCustom process, List<String> parentsToExclude) throws SAXException {
        this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
        this.packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
        this.packOut.createGenericPO(document, (PO)process, true, parentsToExclude);
        List parametersList = new Query(ctx, "AD_ProcessParaCustom", "AD_ProcessCustom_ID = ?", null).setParameters(new Object[]{process.getAD_ProcessCustom_ID()}).setOnlyActiveRecords(true).list();
        for (MProcessParaCustom parameter : parametersList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
            this.packOut.createGenericPO(document, (PO)parameter, true, parentsToExclude);
        }
    }

    private void createCustomBrowser(Properties ctx, TransformerHandler document, MBrowseCustom browser, List<String> parentsToExclude) throws SAXException {
        this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
        this.packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
        this.packOut.createGenericPO(document, (PO)browser, true, parentsToExclude);
        List fieldList = new Query(ctx, "AD_BrowseFieldCustom", "AD_BrowseCustom_ID = ?", null).setParameters(new Object[]{browser.getAD_BrowseCustom_ID()}).setOnlyActiveRecords(true).list();
        for (MBrowseFieldCustom field : fieldList) {
            this.packOut.getGenericPOHandler().setIgnoreWhenMissingMandatoryReference(true);
            this.packOut.getGenericPOHandler().setIgnoreWhenSaveError(true);
            this.packOut.createGenericPO(document, (PO)field, true, parentsToExclude);
        }
    }
}

