/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca54.util;

import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.process.GenerateShipmentOutBound;
import org.eevolution.service.dsl.ProcessBuilder;

public class SalesOrderImprovementsUtil {
    public static final String COLUMNNAME_ECA54_AutoCloseOrder = "ECA54_AutoCloseOrder";
    public static final String COLUMNNAME_ECA54_AutoShipment = "ECA54_AutoShipment";
    public static final String COLUMNNAME_ECA54_DisableDiscount = "ECA54_DisableDiscount";
    public static final String DOCACTION = "DocAction";
    private static final String ISINCLUDENOTAVAILABLE = "IsIncludeNotAvailable";
    private static final String MOVEMENTDATE = "MovementDate";

    public static void generateShipmentFromInvoiceOfOutBoundOrder(MInvoice invoice) {
        if (invoice.getC_Order_ID() <= 0) {
            return;
        }
        if (invoice.getC_Order().isDelivered()) {
            return;
        }
        ProcessInfo processInformation = ProcessBuilder.create((Properties)invoice.getCtx()).process(Integer.valueOf(GenerateShipmentOutBound.getProcessId())).withoutTransactionClose().withParameter(DOCACTION, (Object)"CO").withParameter(ISINCLUDENOTAVAILABLE, (Object)true).withParameter(MOVEMENTDATE, (Object)invoice.getDateInvoiced()).withSelectedRecordsIds(MWMInOutBound.Table_ID, SalesOrderImprovementsUtil.getInOutboundLinesIdsFromInvoice(invoice)).execute(invoice.get_TrxName());
        if (processInformation.isError()) {
            throw new AdempiereException(processInformation.getSummary());
        }
    }

    private static List<Integer> getInOutboundLinesIdsFromInvoice(MInvoice invoice) {
        return new Query(invoice.getCtx(), "WM_InOutBoundLine", "EXISTS(SELECT 1 FROM C_InvoiceLine il WHERE il.WM_InOutBoundLine_ID = WM_InOutBoundLine.WM_InOutBoundLine_ID AND il.C_Invoice_ID = ?)", invoice.get_TrxName()).setParameters(new Object[]{invoice.getC_Invoice_ID()}).getIDsAsList();
    }
}

