/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca54.process;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.Query;
import org.compiere.util.Trx;
import org.spin.eca54.process.CloseCompleteOrdersAbstract;

public class CloseCompleteOrders
extends CloseCompleteOrdersAbstract {
    private int counter = 0;
    private int errCounter = 0;

    protected String doIt() throws Exception {
        new Query(this.getCtx(), "C_Order", "IsSOTrx = 'Y'AND DocStatus = 'CO' AND TO_DATE(Updated, 'YYYY-MM-DD') = ? AND EXISTS(SELECT 1 FROM C_DocType dt WHERE dt.C_DocType_ID = C_Order.C_DocTypeTarget_ID AND dt.ECA54_AutoCloseOrder = 'Y') AND NOT EXISTS(SELECT 1 FROM C_OrderLine ol \tWHERE ol.C_Order_ID = C_Order.C_Order_ID \tAND COALESCE(ol.QtyDelivered, 0) <> ol.QtyOrdered \tAND COALESCE(ol.QtyInvoiced, 0) <> ol.QtyOrdered)", this.get_TrxName()).setParameters(new Object[]{this.getDateOrdered()}).setClient_ID().getIDsAsList().forEach(orderId -> this.process((int)orderId));
        return "@Updated@=" + this.counter + ", @Errors@=" + this.errCounter;
    }

    private boolean process(int orderId) {
        try {
            Trx.run(trxName -> {
                MOrder order = new MOrder(this.getCtx(), orderId, trxName);
                this.log.info(order.toString());
                order.setDocAction("CL");
                if (!order.processIt("CL")) {
                    this.addLog(0, null, null, order.getDocumentNo() + ": @Error@ " + order.getProcessMsg());
                    throw new AdempiereException(order.getDocumentNo() + ": @Error@ " + order.getProcessMsg());
                }
                order.saveEx();
                this.addLog(0, null, null, order.getDocumentNo() + ": @OK@");
            });
            ++this.counter;
        }
        catch (Exception e) {
            ++this.errCounter;
            this.addLog(e.getMessage());
            this.log.warning(e.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

