/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca54.model.validator;

import java.util.Properties;
import org.compiere.model.I_C_Order;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.eca54.util.SalesOrderImprovementsUtil;

public class SalesOrderAndInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(SalesOrderAndInvoice.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if ((type == 1 || type == 2) && entity.get_TableName().equals("C_OrderLine") && (entity.is_new() || entity.is_ValueChanged("PriceActual"))) {
            MOrderLine orderLine = (MOrderLine)entity;
            I_C_Order order = orderLine.getC_Order();
            MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)order.getC_DocTypeTarget_ID());
            if (documentType.get_ValueAsBoolean("ECA54_DisableDiscount")) {
                orderLine.setPriceList(orderLine.getPriceActual());
                orderLine.setDiscount(Env.ZERO);
            }
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        MInvoice invoice;
        if (timing == 9 && entity.get_TableName().equals("C_Invoice") && (invoice = (MInvoice)entity).getC_Order_ID() > 0) {
            I_C_Order order = invoice.getC_Order();
            MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)order.getC_DocTypeTarget_ID());
            if (invoice.isSOTrx() && !invoice.isReversal() && documentType.get_ValueAsBoolean("ECA54_AutoShipment")) {
                SalesOrderImprovementsUtil.generateShipmentFromInvoiceOfOutBoundOrder(invoice);
            }
        }
        return null;
    }
}

