/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfAStamperImp;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PdfAStamper
extends PdfStamper {
    public PdfAStamper(PdfReader reader, OutputStream os, PdfAConformanceLevel conformanceLevel) throws DocumentException, IOException {
        this.stamper = new PdfAStamperImp(reader, os, '\u0000', false, conformanceLevel);
    }

    public PdfAStamper(PdfReader reader, OutputStream os, char pdfVersion, PdfAConformanceLevel conformanceLevel) throws DocumentException, IOException {
        this.stamper = new PdfAStamperImp(reader, os, pdfVersion, false, conformanceLevel);
    }

    public PdfAStamper(PdfReader reader, OutputStream os, char pdfVersion, boolean append, PdfAConformanceLevel conformanceLevel) throws DocumentException, IOException {
        this.stamper = new PdfAStamperImp(reader, os, pdfVersion, append, conformanceLevel);
    }

    public static PdfAStamper createSignature(PdfReader reader, OutputStream os, char pdfVersion, File tempFile, boolean append, PdfAConformanceLevel conformanceLevel) throws DocumentException, IOException {
        PdfAStamper stp;
        if (tempFile == null) {
            ByteBuffer bout = new ByteBuffer();
            stp = new PdfAStamper(reader, (OutputStream)bout, pdfVersion, append, conformanceLevel);
            stp.sigApp = new PdfSignatureAppearance(stp.stamper);
            stp.sigApp.setSigout(bout);
        } else {
            if (tempFile.isDirectory()) {
                tempFile = File.createTempFile("pdf", null, tempFile);
            }
            FileOutputStream fout = new FileOutputStream(tempFile);
            stp = new PdfAStamper(reader, fout, pdfVersion, append, conformanceLevel);
            stp.sigApp = new PdfSignatureAppearance(stp.stamper);
            stp.sigApp.setTempFile(tempFile);
        }
        stp.sigApp.setOriginalout(os);
        stp.sigApp.setStamper((PdfStamper)stp);
        stp.hasSignature = true;
        PdfDictionary catalog = reader.getCatalog();
        PdfDictionary acroForm = (PdfDictionary)PdfReader.getPdfObject((PdfObject)catalog.get(PdfName.ACROFORM), (PdfObject)catalog);
        if (acroForm != null) {
            acroForm.remove(PdfName.NEEDAPPEARANCES);
            stp.stamper.markUsed((PdfObject)acroForm);
        }
        return stp;
    }

    public static PdfAStamper createSignature(PdfReader reader, OutputStream os, char pdfVersion, PdfAConformanceLevel conformanceLevel) throws DocumentException, IOException {
        return PdfAStamper.createSignature(reader, os, pdfVersion, null, false, conformanceLevel);
    }

    public static PdfAStamper createSignature(PdfReader reader, OutputStream os, char pdfVersion, File tempFile, PdfAConformanceLevel conformanceLevel) throws DocumentException, IOException {
        return PdfAStamper.createSignature(reader, os, pdfVersion, tempFile, false, conformanceLevel);
    }
}

