/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model.validator;

import java.util.Properties;
import org.compiere.model.I_C_ConversionType;
import org.compiere.model.MClient;
import org.compiere.model.MConversionType;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.eevolution.model.I_PP_Product_BOM;
import org.eevolution.model.MPPProductBOM;

public class ChangeIsDefaultAttribute
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ChangeIsDefaultAttribute.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("PP_Product_BOM", (ModelValidator)this);
        engine.addModelChange("C_ConversionType", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (type == 5 && po.is_ValueChanged("IsDefault") && po.get_ValueAsBoolean("IsDefault")) {
            if (po.get_Table_ID() == I_PP_Product_BOM.Table_ID) {
                MPPProductBOM productBOM = (MPPProductBOM)po;
                this.updateIsDefaultValue(productBOM.getCtx(), productBOM.get_TableName(), "PP_Product_BOM_ID <> " + productBOM.getPP_Product_BOM_ID() + " AND " + "M_Product_ID" + " = " + productBOM.getM_Product_ID(), productBOM.get_TrxName());
            } else if (po.get_Table_ID() == I_C_ConversionType.Table_ID) {
                MConversionType conversionType = (MConversionType)po;
                this.updateIsDefaultValue(conversionType.getCtx(), conversionType.get_TableName(), "C_ConversionType_ID <> " + conversionType.getC_ConversionType_ID(), conversionType.get_TrxName());
            }
        }
        return null;
    }

    private void updateIsDefaultValue(Properties context, String tableName, String whereClause, String trxName) {
        new Query(context, tableName, whereClause + " AND " + "IsDefault" + " = 'Y'", trxName).setClient_ID().setOnlyActiveRecords(true).list().forEach(objectToChange -> {
            objectToChange.set_ValueOfColumn("IsDefault", (Object)false);
            objectToChange.save();
        });
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

