/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tpa.model.validator;

import java.util.Properties;
import org.compiere.model.I_C_BPartner;
import org.compiere.model.I_C_Project;
import org.compiere.model.MClient;
import org.compiere.model.MProject;
import org.compiere.model.MRecordAccess;
import org.compiere.model.MUser;
import org.compiere.model.MUserRoles;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.eevolution.model.MProjectMember;

public class ThirdPartyAccess
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ThirdPartyAccess.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_ProjectMember", (ModelValidator)this);
        engine.addModelChange("AD_User_Roles", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (type == 4) {
            if (po instanceof MProjectMember) {
                this.addUserAccessToProjectMember((MProjectMember)po);
            } else if (po instanceof MUserRoles) {
                MUserRoles userRoles = (MUserRoles)po;
                MUser user = new MUser(userRoles.getCtx(), userRoles.getAD_User_ID(), userRoles.get_TrxName());
                if (user.isProjectMember() && !user.get_ValueAsBoolean("IsProjectManager")) {
                    this.addUserAccessToProject(userRoles.getCtx(), 0, user.getAD_User_ID(), userRoles.get_TrxName());
                }
                this.addUserAccessToBusinessPartner(userRoles.getCtx(), user, userRoles.get_TrxName());
            }
        } else if (type == 5) {
            if (po instanceof MProjectMember) {
                if (po.is_ValueChanged("IsActive")) {
                    MProjectMember projectMember = (MProjectMember)po;
                    if (projectMember.isActive()) {
                        this.addUserAccessToProjectMember(projectMember);
                    } else {
                        this.removeUserAccessToProjectMember(projectMember);
                    }
                }
            } else if (po instanceof MUserRoles) {
                MUserRoles userRoles = (MUserRoles)po;
                MUser user = new MUser(userRoles.getCtx(), userRoles.getAD_User_ID(), userRoles.get_TrxName());
                if (userRoles.isActive()) {
                    this.addUserAccessToBusinessPartner(userRoles.getCtx(), user, userRoles.get_TrxName());
                } else {
                    this.removeUserAccessToBusinessPartner(userRoles.getCtx(), user, userRoles.get_TrxName());
                }
            }
        } else if (type == 6 && po instanceof MUserRoles) {
            MUserRoles userRoles = (MUserRoles)po;
            MUser user = MUser.get((Properties)userRoles.getCtx(), (int)userRoles.getAD_User_ID());
            this.removeUserAccessToBusinessPartner(userRoles.getCtx(), user, userRoles.get_TrxName());
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }

    private void addUserAccessToProjectMember(MProjectMember projectMember) {
        MProject project = MProject.getById((Properties)projectMember.getCtx(), (Integer)projectMember.getC_Project_ID(), (String)projectMember.get_TrxName());
        if (!project.get_ValueAsBoolean("IsControlAccessManage")) {
            return;
        }
        MUser user = MUser.get((Properties)projectMember.getCtx(), (int)projectMember.getAD_User_ID());
        if (user.get_ValueAsBoolean("IsProjectManager")) {
            return;
        }
        MRecordAccess accessForUser = new MRecordAccess(projectMember.getCtx(), -1, I_C_Project.Table_ID, projectMember.getC_Project_ID(), projectMember.get_TrxName());
        accessForUser.set_ValueOfColumn("AD_User_ID", (Object)projectMember.getAD_User_ID());
        accessForUser.setIsExclude(false);
        accessForUser.setIsReadOnly(false);
        accessForUser.setIsDependentEntities(true);
        accessForUser.saveEx();
    }

    private void addUserAccessToProject(Properties context, int projectId, int userId, String trxName) {
        MRecordAccess currentRecordAccess = (MRecordAccess)new Query(context, "AD_Record_Access", "AD_User_ID = ? AND AD_Table_ID = ? AND Record_ID = ?", trxName).setParameters(new Object[]{userId, I_C_Project.Table_ID, projectId}).first();
        if (currentRecordAccess != null && currentRecordAccess.getAD_Table_ID() != 0) {
            return;
        }
        MRecordAccess accessForUser = new MRecordAccess(context, -1, I_C_Project.Table_ID, projectId, trxName);
        accessForUser.set_ValueOfColumn("AD_User_ID", (Object)userId);
        accessForUser.setIsExclude(false);
        accessForUser.setIsReadOnly(false);
        accessForUser.setIsDependentEntities(true);
        accessForUser.saveEx();
    }

    private void removeUserAccessToProjectMember(MProjectMember projectMember) {
        MUser user = MUser.get((Properties)projectMember.getCtx(), (int)projectMember.getAD_User_ID());
        if (user.get_ValueAsBoolean("IsProjectManager")) {
            return;
        }
        new Query(projectMember.getCtx(), "AD_Record_Access", "AD_User_ID = ? AND AD_Table_ID = ? AND Record_ID = ?", projectMember.get_TrxName()).setParameters(new Object[]{projectMember.getAD_User_ID(), I_C_Project.Table_ID, projectMember.getC_Project_ID()}).list().stream().forEach(access -> access.deleteEx(true));
    }

    private void addUserAccessToBusinessPartner(Properties context, MUser user, String trxName) {
        if (user.isInternalUser() || !user.isLoginUser() || user.getC_BPartner_ID() == 0) {
            return;
        }
        MRecordAccess currentRecordAccess = (MRecordAccess)new Query(context, "AD_Record_Access", "AD_User_ID = ? AND AD_Table_ID = ? AND Record_ID = ?", trxName).setParameters(new Object[]{user.getAD_User_ID(), I_C_BPartner.Table_ID, user.getC_BPartner_ID()}).first();
        if (currentRecordAccess != null && currentRecordAccess.getAD_Table_ID() != 0) {
            return;
        }
        MRecordAccess accessForUser = new MRecordAccess(context, -1, I_C_BPartner.Table_ID, user.getC_BPartner_ID(), trxName);
        accessForUser.set_ValueOfColumn("AD_User_ID", (Object)user.getAD_User_ID());
        accessForUser.setIsExclude(false);
        accessForUser.setIsReadOnly(false);
        accessForUser.saveEx();
    }

    private void removeUserAccessToBusinessPartner(Properties context, MUser user, String trxName) {
        if (user.isInternalUser() || !user.isLoginUser() || user.getC_BPartner_ID() == 0) {
            return;
        }
        new Query(context, "AD_Record_Access", "AD_User_ID = ? AND AD_Table_ID = ? AND Record_ID = ?", trxName).setParameters(new Object[]{user.getAD_User_ID(), I_C_BPartner.Table_ID, user.getC_BPartner_ID()}).list().stream().forEach(access -> access.deleteEx(true));
    }
}

