/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class SerializableCookieJar
implements CookieJar,
Serializable {
    private static final long serialVersionUID = -837498359387593793L;
    Map<String, List<SerializableCookie>> map = new HashMap<String, List<SerializableCookie>>();

    public List<Cookie> loadForRequest(HttpUrl url) {
        return ((List)this.map.getOrDefault(url.host(), new ArrayList())).stream().map(c -> ((SerializableCookie)c).cookie).collect(Collectors.toList());
    }

    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        List list = cookies.stream().map(c -> new SerializableCookie((Cookie)c)).collect(Collectors.toList());
        if (this.map.putIfAbsent(url.host(), list) != null) {
            this.map.get(url.host()).addAll(list);
        }
    }

    public static class SerializableCookie
    implements Serializable {
        private static final long serialVersionUID = -8594045714036645534L;
        private transient Cookie cookie;
        private static long NON_VALID_EXPIRES_AT = -1L;

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.cookie.name());
            out.writeObject(this.cookie.value());
            out.writeLong(this.cookie.persistent() ? this.cookie.expiresAt() : NON_VALID_EXPIRES_AT);
            out.writeObject(this.cookie.domain());
            out.writeObject(this.cookie.path());
            out.writeBoolean(this.cookie.secure());
            out.writeBoolean(this.cookie.httpOnly());
            out.writeBoolean(this.cookie.hostOnly());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Cookie.Builder builder = new Cookie.Builder();
            builder.name((String)in.readObject());
            builder.value((String)in.readObject());
            long expiresAt = in.readLong();
            if (expiresAt != NON_VALID_EXPIRES_AT) {
                builder.expiresAt(expiresAt);
            }
            String domain = (String)in.readObject();
            builder.domain(domain);
            builder.path((String)in.readObject());
            if (in.readBoolean()) {
                builder.secure();
            }
            if (in.readBoolean()) {
                builder.httpOnly();
            }
            if (in.readBoolean()) {
                builder.hostOnlyDomain(domain);
            }
            this.cookie = builder.build();
        }

        public SerializableCookie(Cookie cookie) {
            this.cookie = cookie;
        }
    }
}

