/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.instagram4j.instagram4j.utils.SerializableCookieJar;
import java.io.ByteArrayOutputStream;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class IGUtils {
    private static final String BASE64URL_CHARMAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectWriter WRITER = MAPPER.writer();
    public static final String XLATE = "0123456789abcdef";

    private IGUtils() {
    }

    protected static String digest(String codec, String source) {
        try {
            MessageDigest digest = MessageDigest.getInstance(codec);
            byte[] digestBytes = digest.digest(source.getBytes(Charset.forName("UTF-8")));
            return IGUtils.hexlate(digestBytes, digestBytes.length);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(codec + " codec not available");
        }
    }

    public static String md5hex(String source) {
        return IGUtils.digest("MD5", source);
    }

    protected static String hexlate(byte[] bytes, int initialCount) {
        if (bytes == null) {
            return "";
        }
        int count = Math.min(initialCount, bytes.length);
        char[] chars = new char[count * 2];
        for (int i = 0; i < count; ++i) {
            int val = bytes[i];
            if (val < 0) {
                val += 256;
            }
            chars[2 * i] = XLATE.charAt(val / 16);
            chars[2 * i + 1] = XLATE.charAt(val % 16);
        }
        return new String(chars);
    }

    public static String generateDeviceId(String username, String password) {
        String seed = IGUtils.md5hex(username + password);
        String volatileSeed = "12345";
        return "android-" + IGUtils.md5hex(seed + volatileSeed).substring(0, 16);
    }

    public static String generateSignature(String payload) {
        String parsedData = URLEncoder.encode(payload, "UTF-8");
        return "signed_body=SIGNATURE." + parsedData;
    }

    public static String toCode(long code) {
        String base2 = Long.toBinaryString(code);
        if (base2.isEmpty()) {
            return "";
        }
        int padAmount = (int)Math.ceil((double)base2.length() / 6.0);
        base2 = String.format("%" + padAmount * 6 + "s", base2).replace(' ', '0');
        String encoded = "";
        for (int i = 0; i < padAmount; ++i) {
            encoded = encoded + BASE64URL_CHARMAP.charAt(Integer.parseInt(base2.substring(6 * i, 6 * i + 6), 2));
        }
        return encoded;
    }

    public static long fromCode(String code) throws IllegalArgumentException {
        if (code == null || code.matches("/[^A-Za-z0-9\\-_]/")) {
            throw new IllegalArgumentException("Input must be a valid Instagram shortcode.");
        }
        String base2 = "";
        for (char c : code.toCharArray()) {
            int base64 = BASE64URL_CHARMAP.indexOf(c);
            base2 = base2 + String.format("%6s", Integer.toBinaryString(base64)).replace(' ', '0');
        }
        return Long.parseLong(base2, 2);
    }

    public static String encryptPassword(String password, String enc_id, String enc_pub_key) {
        byte[] rand_key = new byte[32];
        byte[] iv = new byte[12];
        SecureRandom sran = new SecureRandom();
        sran.nextBytes(rand_key);
        sran.nextBytes(iv);
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String decoded_pub_key = new String(Base64.getDecoder().decode(enc_pub_key), StandardCharsets.UTF_8).replaceAll("-(.*)-|\n", "");
        Cipher rsa_cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
        rsa_cipher.init(1, KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(decoded_pub_key))));
        byte[] rand_key_encrypted = rsa_cipher.doFinal(rand_key);
        Cipher aes_gcm_cipher = Cipher.getInstance("AES/GCM/NoPadding");
        aes_gcm_cipher.init(1, (Key)new SecretKeySpec(rand_key, "AES"), new GCMParameterSpec(128, iv));
        aes_gcm_cipher.updateAAD(time.getBytes());
        byte[] password_encrypted = aes_gcm_cipher.doFinal(password.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(Integer.valueOf(1).byteValue());
        out.write(Integer.valueOf(enc_id).byteValue());
        out.write(iv);
        out.write(ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putChar((char)rand_key_encrypted.length).array());
        out.write(rand_key_encrypted);
        out.write(Arrays.copyOfRange(password_encrypted, password_encrypted.length - 16, password_encrypted.length));
        out.write(Arrays.copyOfRange(password_encrypted, 0, password_encrypted.length - 16));
        return String.format("#PWD_INSTAGRAM:%s:%s:%s", "4", time, Base64.getEncoder().encodeToString(out.toByteArray()));
    }

    public static OkHttpClient.Builder defaultHttpClientBuilder() {
        return new OkHttpClient.Builder().cookieJar((CookieJar)new SerializableCookieJar());
    }

    public static String randomUuid() {
        return UUID.randomUUID().toString();
    }

    public static String objectToJson(Object obj) {
        return WRITER.writeValueAsString(obj);
    }

    public static <T> T jsonToObject(String json, Class<T> view) throws JsonProcessingException {
        return (T)MAPPER.readValue(json, view);
    }

    public static <T> T convertToView(Object o, Class<T> view) {
        return (T)MAPPER.convertValue(o, view);
    }

    public static <T> T convertToView(Object o, TypeReference<T> type) {
        return (T)MAPPER.convertValue(o, type);
    }

    public static Optional<String> getCookieValue(CookieJar jar, String key) {
        return jar.loadForRequest(HttpUrl.get((String)"https://i.instagram.com/")).stream().filter(cookie -> cookie.name().equals(key)).map(Cookie::value).findAny();
    }

    public static String truncate(String s) {
        return s != null ? s.substring(0, Math.min(100, s.length())) : s;
    }

    public static void sleepSeconds(long seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

