/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.users;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.requests.IGGetRequest;
import com.github.instagram4j.instagram4j.responses.users.UsersSearchResponse;
import lombok.NonNull;

public class UsersSearchRequest
extends IGGetRequest<UsersSearchResponse> {
    @NonNull
    private String query;
    private int timezone_offset = 3600;
    private String rank_token;
    private String page_token;
    private final String search_surface = "user_search_page";
    private final int count = 30;

    public UsersSearchRequest(String _query, String _rank_token, String _page_token) {
        this.query = _query;
        this.rank_token = _rank_token;
        this.page_token = _page_token;
    }

    @Override
    public String getQueryString(IGClient client) {
        return this.mapQueryString("search_surface", "user_search_page", "timezone_offset", this.timezone_offset, "q", this.query, "count", 30, "rank_token", this.rank_token, "page_token", this.page_token);
    }

    @Override
    public String path() {
        return "users/search/";
    }

    @Override
    public Class<UsersSearchResponse> getResponseType() {
        return UsersSearchResponse.class;
    }

    public UsersSearchRequest(@NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        this.query = query;
    }

    public UsersSearchRequest(@NonNull String query, int timezone_offset, String rank_token, String page_token) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        this.query = query;
        this.timezone_offset = timezone_offset;
        this.rank_token = rank_token;
        this.page_token = page_token;
    }
}

