/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.upload;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.models.media.UploadParameters;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import java.util.concurrent.ThreadLocalRandom;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class RuploadVideoRequest
extends IGPostRequest<IGResponse> {
    private byte[] videoData;
    private UploadParameters upload_params;
    private final String name;

    public RuploadVideoRequest(byte[] data, UploadParameters param) {
        this.videoData = data;
        this.upload_params = param;
        this.name = this.upload_params.getUpload_id() + "_0_" + ThreadLocalRandom.current().nextLong(1000000000L, 9999999999L);
    }

    @Override
    protected IGPayload getPayload(IGClient client) {
        return null;
    }

    @Override
    public String apiPath() {
        return "";
    }

    @Override
    public String path() {
        return "rupload_igvideo/" + this.name;
    }

    @Override
    public Request.Builder applyHeaders(IGClient client, Request.Builder req) {
        super.applyHeaders(client, req);
        req.addHeader("X-Instagram-Rupload-Params", IGUtils.objectToJson(this.upload_params));
        req.addHeader("X_FB_VIDEO_WATERFALL_ID", IGUtils.randomUuid());
        req.addHeader("X-Entity-Type", "video/mp4");
        req.addHeader("Offset", "0");
        req.addHeader("X-Entity-Name", this.name);
        req.addHeader("X-Entity-Length", String.valueOf(this.videoData.length));
        return req;
    }

    @Override
    public RequestBody getRequestBody(IGClient client) {
        return RequestBody.create((byte[])this.videoData, (MediaType)MediaType.get((String)"application/octet-stream"));
    }

    @Override
    public Class<IGResponse> getResponseType() {
        return IGResponse.class;
    }
}

