/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.upload;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.models.media.UploadParameters;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import lombok.NonNull;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class RuploadSegmentVideoPhaseRequest
extends IGPostRequest<IGResponse> {
    @NonNull
    private Phase phase;
    @NonNull
    private UploadParameters upload_params;
    private String stream_id;
    private String transfer_id;
    private String segment_offset;
    private String total_entity_length;
    private byte[] body;
    private final String uuid = IGUtils.randomUuid();

    public RuploadSegmentVideoPhaseRequest(Phase phase, UploadParameters param, String stream_id, String transfer_id) {
        this(phase, param);
        this.transfer_id = transfer_id;
        this.stream_id = stream_id;
    }

    @Override
    public String apiPath() {
        return "";
    }

    @Override
    public String path() {
        return "rupload_igvideo/" + (this.phase != Phase.START ? this.transfer_id : this.uuid);
    }

    @Override
    public String getQueryString(IGClient client) {
        return this.mapQueryString("segmented", "true", "phase", this.phase.name().toLowerCase());
    }

    @Override
    public Request.Builder applyHeaders(IGClient client, Request.Builder req) {
        super.applyHeaders(client, req);
        req.addHeader("X-Instagram-Rupload-Params", IGUtils.objectToJson(this.upload_params));
        req.addHeader("X_FB_WATERFALL_ID", IGUtils.randomUuid());
        this.addHeadersBaseOnPhase(req);
        return req;
    }

    @Override
    public Class<IGResponse> getResponseType() {
        return IGResponse.class;
    }

    @Override
    protected IGPayload getPayload(IGClient client) {
        return null;
    }

    @Override
    public RequestBody getRequestBody(IGClient client) {
        return this.phase == Phase.TRANSFER ? RequestBody.create((byte[])this.body, (MediaType)MediaType.get((String)"application/octet-stream")) : super.getRequestBody(client);
    }

    public void addHeadersBaseOnPhase(Request.Builder req) {
        switch (this.phase) {
            default: {
                return;
            }
            case TRANSFER: {
                this.phase.addToHeader(req, this.stream_id, "2", this.segment_offset, this.total_entity_length, this.transfer_id, "video/mp4", this.segment_offset);
                break;
            }
            case END: {
                this.phase.addToHeader(req, this.stream_id);
            }
        }
    }

    public RuploadSegmentVideoPhaseRequest(@NonNull Phase phase, @NonNull UploadParameters upload_params) {
        if (phase == null) {
            throw new NullPointerException("phase is marked non-null but is null");
        }
        if (upload_params == null) {
            throw new NullPointerException("upload_params is marked non-null but is null");
        }
        this.phase = phase;
        this.upload_params = upload_params;
    }

    public RuploadSegmentVideoPhaseRequest(@NonNull Phase phase, @NonNull UploadParameters upload_params, String stream_id, String transfer_id, String segment_offset, String total_entity_length, byte[] body) {
        if (phase == null) {
            throw new NullPointerException("phase is marked non-null but is null");
        }
        if (upload_params == null) {
            throw new NullPointerException("upload_params is marked non-null but is null");
        }
        this.phase = phase;
        this.upload_params = upload_params;
        this.stream_id = stream_id;
        this.transfer_id = transfer_id;
        this.segment_offset = segment_offset;
        this.total_entity_length = total_entity_length;
        this.body = body;
    }

    public static enum Phase {
        START(new String[0]),
        TRANSFER("Stream-Id", "Segment-Type", "Segment-Start-Offset", "X-Entity-Length", "X-Entity-Name", "X-Entity-Type", "Offset"),
        END("Stream-Id");

        private String[] headers;

        private Phase(String ... headers) {
            this.headers = headers;
        }

        public void addToHeader(Request.Builder req, String ... values) {
            for (int i = 0; i < this.headers.length; ++i) {
                req.addHeader(this.headers[i], values[i]);
            }
        }

        public String[] getHeaders() {
            return this.headers;
        }
    }
}

