/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.upload;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.media.UploadParameters;
import com.github.instagram4j.instagram4j.requests.IGGetRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import lombok.NonNull;
import okhttp3.Request;

public class RuploadSegmentVideoGetRequest
extends IGGetRequest<IGResponse> {
    @NonNull
    private UploadParameters param;
    @NonNull
    private String stream_id;
    @NonNull
    private String transfer_id;
    @NonNull
    private String segment_offset;

    @Override
    public String apiPath() {
        return "";
    }

    @Override
    public String path() {
        return "rupload_igvideo/" + this.transfer_id;
    }

    @Override
    public Request.Builder applyHeaders(IGClient client, Request.Builder req) {
        super.applyHeaders(client, req);
        req.addHeader("X-Instagram-Rupload-Params", IGUtils.objectToJson(this.param));
        req.addHeader("Stream-Id", this.stream_id);
        req.addHeader("Segment-Type", "2");
        req.addHeader("Segment-Start-Offset", this.segment_offset);
        req.addHeader("X_FB_WATERFALL_ID", IGUtils.randomUuid());
        return req;
    }

    @Override
    public Class<IGResponse> getResponseType() {
        return IGResponse.class;
    }

    public RuploadSegmentVideoGetRequest(@NonNull UploadParameters param, @NonNull String stream_id, @NonNull String transfer_id, @NonNull String segment_offset) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        if (stream_id == null) {
            throw new NullPointerException("stream_id is marked non-null but is null");
        }
        if (transfer_id == null) {
            throw new NullPointerException("transfer_id is marked non-null but is null");
        }
        if (segment_offset == null) {
            throw new NullPointerException("segment_offset is marked non-null but is null");
        }
        this.param = param;
        this.stream_id = stream_id;
        this.transfer_id = transfer_id;
        this.segment_offset = segment_offset;
    }
}

