/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.upload;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.models.media.UploadParameters;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.media.RuploadPhotoResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import java.util.concurrent.ThreadLocalRandom;
import lombok.NonNull;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class RuploadPhotoRequest
extends IGPostRequest<RuploadPhotoResponse> {
    @NonNull
    private byte[] imgData;
    @NonNull
    private String mediaType;
    private String uploadId = String.valueOf(System.currentTimeMillis());
    private boolean isSidecar = false;
    private final String name = this.uploadId + "_0_" + ThreadLocalRandom.current().nextLong(1000000000L, 9999999999L);

    @Override
    public String apiPath() {
        return "";
    }

    @Override
    public IGPayload getPayload(IGClient client) {
        return null;
    }

    @Override
    protected Request.Builder applyHeaders(IGClient client, Request.Builder req) {
        super.applyHeaders(client, req);
        req.addHeader("X-Instagram-Rupload-Params", UploadParameters.forPhoto(this.uploadId, this.mediaType, this.isSidecar).toString());
        req.addHeader("X_FB_WATERFALL_ID", IGUtils.randomUuid());
        req.addHeader("Accept-Encoding", "gzip");
        req.addHeader("X-Entity-Name", this.name);
        req.addHeader("X-Entity-Type", "image/jpeg");
        req.addHeader("X-Entity-Length", String.valueOf(this.imgData.length));
        req.addHeader("Offset", "0");
        return req;
    }

    @Override
    protected RequestBody getRequestBody(IGClient client) {
        return RequestBody.create((byte[])this.imgData, (MediaType)MediaType.get((String)"application/octet-stream"));
    }

    @Override
    public String path() {
        return "rupload_igphoto/" + this.name;
    }

    @Override
    public Class<RuploadPhotoResponse> getResponseType() {
        return RuploadPhotoResponse.class;
    }

    public RuploadPhotoRequest(@NonNull byte[] imgData, @NonNull String mediaType) {
        if (imgData == null) {
            throw new NullPointerException("imgData is marked non-null but is null");
        }
        if (mediaType == null) {
            throw new NullPointerException("mediaType is marked non-null but is null");
        }
        this.imgData = imgData;
        this.mediaType = mediaType;
    }

    public RuploadPhotoRequest(@NonNull byte[] imgData, @NonNull String mediaType, String uploadId, boolean isSidecar) {
        if (imgData == null) {
            throw new NullPointerException("imgData is marked non-null but is null");
        }
        if (mediaType == null) {
            throw new NullPointerException("mediaType is marked non-null but is null");
        }
        this.imgData = imgData;
        this.mediaType = mediaType;
        this.uploadId = uploadId;
        this.isSidecar = isSidecar;
    }
}

