/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.tags;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.requests.IGGetRequest;
import com.github.instagram4j.instagram4j.requests.IGPageRankTokenRequest;
import com.github.instagram4j.instagram4j.responses.tags.TagsSearchResponse;
import lombok.NonNull;

public class TagsSearchRequest
extends IGGetRequest<TagsSearchResponse>
implements IGPageRankTokenRequest {
    @NonNull
    private String query;
    private Double lat;
    private Double lon;
    private String page_token;
    private String rank_token;
    private final int count = 30;

    @Override
    public String path() {
        return "tags/search";
    }

    @Override
    public String getQueryString(IGClient client) {
        return this.mapQueryString("search_surface", "hashtag_search_page", "timezone_offset", "0", "q", this.query, "lat", this.lat, "lng", this.lon, "count", 30, "rank_token", this.rank_token, "page_token", this.page_token);
    }

    @Override
    public Class<TagsSearchResponse> getResponseType() {
        return TagsSearchResponse.class;
    }

    public TagsSearchRequest(@NonNull String query, Double lat, Double lon, String page_token, String rank_token) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        this.query = query;
        this.lat = lat;
        this.lon = lon;
        this.page_token = page_token;
        this.rank_token = rank_token;
    }

    public TagsSearchRequest(@NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        this.query = query;
    }

    @Override
    public void setPage_token(String page_token) {
        this.page_token = page_token;
    }

    @Override
    public void setRank_token(String rank_token) {
        this.rank_token = rank_token;
    }
}

