/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.music;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.music.MusicTrackResponse;
import lombok.NonNull;

public class MusicSearchRequest
extends IGPostRequest<MusicTrackResponse> {
    @NonNull
    private String _query;
    private String _cursor = "0";

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new MusicQueryPayload(client.getSessionId(), this._cursor, this._query);
    }

    @Override
    public String path() {
        return "music/search/";
    }

    @Override
    public Class<MusicTrackResponse> getResponseType() {
        return MusicTrackResponse.class;
    }

    public MusicSearchRequest(@NonNull String _query) {
        if (_query == null) {
            throw new NullPointerException("_query is marked non-null but is null");
        }
        this._query = _query;
    }

    public MusicSearchRequest(@NonNull String _query, String _cursor) {
        if (_query == null) {
            throw new NullPointerException("_query is marked non-null but is null");
        }
        this._query = _query;
        this._cursor = _cursor;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected static class MusicQueryPayload
    extends IGPayload {
        @NonNull
        private String browse_session_id;
        @NonNull
        private String cursor;
        private String q;

        @NonNull
        public String getBrowse_session_id() {
            return this.browse_session_id;
        }

        @NonNull
        public String getCursor() {
            return this.cursor;
        }

        public String getQ() {
            return this.q;
        }

        public void setBrowse_session_id(@NonNull String browse_session_id) {
            if (browse_session_id == null) {
                throw new NullPointerException("browse_session_id is marked non-null but is null");
            }
            this.browse_session_id = browse_session_id;
        }

        public void setCursor(@NonNull String cursor) {
            if (cursor == null) {
                throw new NullPointerException("cursor is marked non-null but is null");
            }
            this.cursor = cursor;
        }

        public void setQ(String q) {
            this.q = q;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MusicQueryPayload)) {
                return false;
            }
            MusicQueryPayload other = (MusicQueryPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$browse_session_id = this.getBrowse_session_id();
            String other$browse_session_id = other.getBrowse_session_id();
            if (this$browse_session_id == null ? other$browse_session_id != null : !this$browse_session_id.equals(other$browse_session_id)) {
                return false;
            }
            String this$cursor = this.getCursor();
            String other$cursor = other.getCursor();
            if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
                return false;
            }
            String this$q = this.getQ();
            String other$q = other.getQ();
            return !(this$q == null ? other$q != null : !this$q.equals(other$q));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MusicQueryPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $browse_session_id = this.getBrowse_session_id();
            result = result * 59 + ($browse_session_id == null ? 43 : $browse_session_id.hashCode());
            String $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            String $q = this.getQ();
            result = result * 59 + ($q == null ? 43 : $q.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MusicSearchRequest.MusicQueryPayload(super=" + super.toString() + ", browse_session_id=" + this.getBrowse_session_id() + ", cursor=" + this.getCursor() + ", q=" + this.getQ() + ")";
        }

        public MusicQueryPayload(@NonNull String browse_session_id, @NonNull String cursor) {
            if (browse_session_id == null) {
                throw new NullPointerException("browse_session_id is marked non-null but is null");
            }
            if (cursor == null) {
                throw new NullPointerException("cursor is marked non-null but is null");
            }
            this.browse_session_id = browse_session_id;
            this.cursor = cursor;
        }

        public MusicQueryPayload(@NonNull String browse_session_id, @NonNull String cursor, String q) {
            if (browse_session_id == null) {
                throw new NullPointerException("browse_session_id is marked non-null but is null");
            }
            if (cursor == null) {
                throw new NullPointerException("cursor is marked non-null but is null");
            }
            this.browse_session_id = browse_session_id;
            this.cursor = cursor;
            this.q = q;
        }
    }
}

