/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.media;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.models.media.reel.ReelMedia;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class MediaSeenRequest
extends IGPostRequest<IGResponse> {
    @NonNull
    private List<ReelMedia> reel_media_ids;

    @Override
    public String apiPath() {
        return "api/v2/";
    }

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new MediaSeenPayload(this.reel_media_ids);
    }

    @Override
    public String path() {
        return "media/seen/";
    }

    @Override
    public String getQueryString(IGClient client) {
        return this.mapQueryString("reel", "1");
    }

    @Override
    public Class<IGResponse> getResponseType() {
        return IGResponse.class;
    }

    public MediaSeenRequest(@NonNull List<ReelMedia> reel_media_ids) {
        if (reel_media_ids == null) {
            throw new NullPointerException("reel_media_ids is marked non-null but is null");
        }
        this.reel_media_ids = reel_media_ids;
    }

    public class MediaSeenPayload
    extends IGPayload {
        private Map<String, String[]> reels = new HashMap<String, String[]>();

        public MediaSeenPayload(List<ReelMedia> reelMedias) {
            reelMedias.forEach(this::map_to_reels);
        }

        public void map_to_reels(ReelMedia media) {
            String key = String.format("%s_%s", media.getId(), media.getUser().getPk());
            String[] value = new String[]{String.format("%s_%s", media.getTaken_at(), System.currentTimeMillis() / 1000L)};
            this.reels.put(key, value);
        }

        public Map<String, String[]> getReels() {
            return this.reels;
        }

        public void setReels(Map<String, String[]> reels) {
            this.reels = reels;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MediaSeenPayload)) {
                return false;
            }
            MediaSeenPayload other = (MediaSeenPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String[]> this$reels = this.getReels();
            Map<String, String[]> other$reels = other.getReels();
            return !(this$reels == null ? other$reels != null : !((Object)this$reels).equals(other$reels));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MediaSeenPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String[]> $reels = this.getReels();
            result = result * 59 + ($reels == null ? 43 : ((Object)$reels).hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MediaSeenRequest.MediaSeenPayload(super=" + super.toString() + ", reels=" + this.getReels() + ")";
        }
    }
}

