/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.media;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.requests.IGGetRequest;
import com.github.instagram4j.instagram4j.requests.IGPaginatedRequest;
import com.github.instagram4j.instagram4j.responses.media.MediaGetStoryQuestionResponsesResponse;
import lombok.NonNull;

public class MediaGetStoryQuestionResponsesRequest
extends IGGetRequest<MediaGetStoryQuestionResponsesResponse>
implements IGPaginatedRequest {
    @NonNull
    private String reel_id;
    @NonNull
    private String question_id;
    private String max_id;

    @Override
    public String path() {
        return String.format("media/%s/%s/story_question_responses/", this.reel_id, this.question_id);
    }

    @Override
    public String getQueryString(IGClient client) {
        return this.mapQueryString("max_id", this.max_id);
    }

    @Override
    public Class<MediaGetStoryQuestionResponsesResponse> getResponseType() {
        return MediaGetStoryQuestionResponsesResponse.class;
    }

    public MediaGetStoryQuestionResponsesRequest(@NonNull String reel_id, @NonNull String question_id) {
        if (reel_id == null) {
            throw new NullPointerException("reel_id is marked non-null but is null");
        }
        if (question_id == null) {
            throw new NullPointerException("question_id is marked non-null but is null");
        }
        this.reel_id = reel_id;
        this.question_id = question_id;
    }

    public MediaGetStoryQuestionResponsesRequest(@NonNull String reel_id, @NonNull String question_id, String max_id) {
        if (reel_id == null) {
            throw new NullPointerException("reel_id is marked non-null but is null");
        }
        if (question_id == null) {
            throw new NullPointerException("question_id is marked non-null but is null");
        }
        this.reel_id = reel_id;
        this.question_id = question_id;
        this.max_id = max_id;
    }

    @Override
    public void setMax_id(String max_id) {
        this.max_id = max_id;
    }
}

