/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.media;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.requests.IGGetRequest;
import com.github.instagram4j.instagram4j.requests.IGPaginatedRequest;
import com.github.instagram4j.instagram4j.responses.media.MediaGetStoryPollVotersResponse;
import lombok.NonNull;

public class MediaGetStoryPollVotersRequest
extends IGGetRequest<MediaGetStoryPollVotersResponse>
implements IGPaginatedRequest {
    @NonNull
    private String reel_id;
    @NonNull
    private String poll_id;
    private String max_id;

    @Override
    public String path() {
        return String.format("media/%s/%s/story_poll_voters/", this.reel_id, this.poll_id);
    }

    @Override
    public String getQueryString(IGClient client) {
        return this.mapQueryString("max_id", this.max_id);
    }

    @Override
    public Class<MediaGetStoryPollVotersResponse> getResponseType() {
        return MediaGetStoryPollVotersResponse.class;
    }

    public MediaGetStoryPollVotersRequest(@NonNull String reel_id, @NonNull String poll_id) {
        if (reel_id == null) {
            throw new NullPointerException("reel_id is marked non-null but is null");
        }
        if (poll_id == null) {
            throw new NullPointerException("poll_id is marked non-null but is null");
        }
        this.reel_id = reel_id;
        this.poll_id = poll_id;
    }

    public MediaGetStoryPollVotersRequest(@NonNull String reel_id, @NonNull String poll_id, String max_id) {
        if (reel_id == null) {
            throw new NullPointerException("reel_id is marked non-null but is null");
        }
        if (poll_id == null) {
            throw new NullPointerException("poll_id is marked non-null but is null");
        }
        this.reel_id = reel_id;
        this.poll_id = poll_id;
        this.max_id = max_id;
    }

    @Override
    public void setMax_id(String max_id) {
        this.max_id = max_id;
    }
}

