/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.media;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.models.media.reel.item.ReelMetadataItem;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.media.MediaResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;

public class MediaConfigureToStoryRequest
extends IGPostRequest<MediaResponse.MediaConfigureToStoryResponse> {
    @NonNull
    private String uploadId;
    private List<ReelMetadataItem> story_metadata;
    private List<String> threadIds;

    public MediaConfigureToStoryRequest(String upload_id, List<ReelMetadataItem> story_metadata) {
        this.uploadId = upload_id;
        this.story_metadata = story_metadata;
    }

    @Override
    protected IGPayload getPayload(IGClient client) {
        return this.constructPayload();
    }

    @Override
    public String path() {
        return "media/configure_to_story/";
    }

    @Override
    public Class<MediaResponse.MediaConfigureToStoryResponse> getResponseType() {
        return MediaResponse.MediaConfigureToStoryResponse.class;
    }

    private MediaConfigureToStoryPayload constructPayload() {
        MediaConfigureToStoryPayload payload = new MediaConfigureToStoryPayload();
        if (this.story_metadata != null) {
            MediaConfigureToStoryRequest.addAllMetadata(payload, this.story_metadata);
        }
        return payload;
    }

    public static void addAllMetadata(MediaConfigureToStoryPayload payload, List<ReelMetadataItem> items) {
        HashMap map = new HashMap();
        items.forEach(item -> {
            if (map.putIfAbsent(item.key(), new ArrayList<ReelMetadataItem>(Arrays.asList(item))) != null) {
                ((List)map.get(item.key())).add(item);
            }
        });
        map.entrySet().forEach(entry -> payload.put((String)entry.getKey(), IGUtils.objectToJson(entry.getValue())));
    }

    public MediaConfigureToStoryRequest(@NonNull String uploadId, List<ReelMetadataItem> story_metadata, List<String> threadIds) {
        if (uploadId == null) {
            throw new NullPointerException("uploadId is marked non-null but is null");
        }
        this.uploadId = uploadId;
        this.story_metadata = story_metadata;
        this.threadIds = threadIds;
    }

    public MediaConfigureToStoryRequest(@NonNull String uploadId) {
        if (uploadId == null) {
            throw new NullPointerException("uploadId is marked non-null but is null");
        }
        this.uploadId = uploadId;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public class MediaConfigureToStoryPayload
    extends IGPayload {
        private String upload_id;
        private String source_type;
        private String configure_mode;
        private List<String> thread_ids;

        public MediaConfigureToStoryPayload() {
            this.upload_id = MediaConfigureToStoryRequest.this.uploadId;
            this.source_type = "3";
            this.configure_mode = MediaConfigureToStoryRequest.this.threadIds == null ? "1" : "2";
            this.thread_ids = MediaConfigureToStoryRequest.this.threadIds;
        }

        public String getUpload_id() {
            return this.upload_id;
        }

        public String getSource_type() {
            return this.source_type;
        }

        public String getConfigure_mode() {
            return this.configure_mode;
        }

        public List<String> getThread_ids() {
            return this.thread_ids;
        }

        public void setUpload_id(String upload_id) {
            this.upload_id = upload_id;
        }

        public void setSource_type(String source_type) {
            this.source_type = source_type;
        }

        public void setConfigure_mode(String configure_mode) {
            this.configure_mode = configure_mode;
        }

        public void setThread_ids(List<String> thread_ids) {
            this.thread_ids = thread_ids;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MediaConfigureToStoryPayload)) {
                return false;
            }
            MediaConfigureToStoryPayload other = (MediaConfigureToStoryPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$upload_id = this.getUpload_id();
            String other$upload_id = other.getUpload_id();
            if (this$upload_id == null ? other$upload_id != null : !this$upload_id.equals(other$upload_id)) {
                return false;
            }
            String this$source_type = this.getSource_type();
            String other$source_type = other.getSource_type();
            if (this$source_type == null ? other$source_type != null : !this$source_type.equals(other$source_type)) {
                return false;
            }
            String this$configure_mode = this.getConfigure_mode();
            String other$configure_mode = other.getConfigure_mode();
            if (this$configure_mode == null ? other$configure_mode != null : !this$configure_mode.equals(other$configure_mode)) {
                return false;
            }
            List<String> this$thread_ids = this.getThread_ids();
            List<String> other$thread_ids = other.getThread_ids();
            return !(this$thread_ids == null ? other$thread_ids != null : !((Object)this$thread_ids).equals(other$thread_ids));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MediaConfigureToStoryPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $upload_id = this.getUpload_id();
            result = result * 59 + ($upload_id == null ? 43 : $upload_id.hashCode());
            String $source_type = this.getSource_type();
            result = result * 59 + ($source_type == null ? 43 : $source_type.hashCode());
            String $configure_mode = this.getConfigure_mode();
            result = result * 59 + ($configure_mode == null ? 43 : $configure_mode.hashCode());
            List<String> $thread_ids = this.getThread_ids();
            result = result * 59 + ($thread_ids == null ? 43 : ((Object)$thread_ids).hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MediaConfigureToStoryRequest.MediaConfigureToStoryPayload(super=" + super.toString() + ", upload_id=" + this.getUpload_id() + ", source_type=" + this.getSource_type() + ", configure_mode=" + this.getConfigure_mode() + ", thread_ids=" + this.getThread_ids() + ")";
        }
    }
}

