/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.media;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.models.location.Location;
import com.github.instagram4j.instagram4j.models.media.UserTags;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.media.MediaResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import java.util.Collections;
import lombok.NonNull;

public class MediaConfigureTimelineRequest
extends IGPostRequest<MediaResponse.MediaConfigureTimelineResponse> {
    @NonNull
    private MediaConfigurePayload payload;

    @Override
    protected IGPayload getPayload(IGClient client) {
        return this.payload;
    }

    @Override
    public String path() {
        return "media/configure/";
    }

    @Override
    public Class<MediaResponse.MediaConfigureTimelineResponse> getResponseType() {
        return MediaResponse.MediaConfigureTimelineResponse.class;
    }

    public MediaConfigureTimelineRequest(@NonNull MediaConfigurePayload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.payload = payload;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class MediaConfigurePayload
    extends IGPayload {
        private String upload_id;
        private String caption = "";
        private String disable_comments;
        private String location;
        private String usertags;

        public MediaConfigurePayload location(Location loc) {
            Location payloadLoc = new Location();
            payloadLoc.setExternal_id(loc.getExternal_id());
            payloadLoc.setName(loc.getName());
            payloadLoc.setAddress(loc.getAddress());
            payloadLoc.setLat(loc.getLat());
            payloadLoc.setLng(loc.getLng());
            payloadLoc.setExternal_source(loc.getExternal_source());
            payloadLoc.put(payloadLoc.getExternal_source() + "_id", payloadLoc.getExternal_id());
            this.location = IGUtils.objectToJson(payloadLoc);
            this.put("geotag_enabled", "1");
            this.put("posting_latitude", payloadLoc.getLat().toString());
            this.put("posting_longitude", payloadLoc.getLng().toString());
            this.put("media_latitude", payloadLoc.getLat().toString());
            this.put("media_longitude", payloadLoc.getLng().toString());
            return this;
        }

        public MediaConfigurePayload usertags(UserTags.UserTagPayload ... tags) {
            this.usertags = IGUtils.objectToJson(Collections.singletonMap("in", tags));
            return this;
        }

        public String usertags() {
            return this.usertags;
        }

        public String upload_id() {
            return this.upload_id;
        }

        public String caption() {
            return this.caption;
        }

        public String disable_comments() {
            return this.disable_comments;
        }

        public String location() {
            return this.location;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MediaConfigurePayload)) {
                return false;
            }
            MediaConfigurePayload other = (MediaConfigurePayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$upload_id = this.upload_id();
            String other$upload_id = other.upload_id();
            if (this$upload_id == null ? other$upload_id != null : !this$upload_id.equals(other$upload_id)) {
                return false;
            }
            String this$caption = this.caption();
            String other$caption = other.caption();
            if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
                return false;
            }
            String this$disable_comments = this.disable_comments();
            String other$disable_comments = other.disable_comments();
            if (this$disable_comments == null ? other$disable_comments != null : !this$disable_comments.equals(other$disable_comments)) {
                return false;
            }
            String this$location = this.location();
            String other$location = other.location();
            if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                return false;
            }
            String this$usertags = this.usertags();
            String other$usertags = other.usertags();
            return !(this$usertags == null ? other$usertags != null : !this$usertags.equals(other$usertags));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MediaConfigurePayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $upload_id = this.upload_id();
            result = result * 59 + ($upload_id == null ? 43 : $upload_id.hashCode());
            String $caption = this.caption();
            result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
            String $disable_comments = this.disable_comments();
            result = result * 59 + ($disable_comments == null ? 43 : $disable_comments.hashCode());
            String $location = this.location();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            String $usertags = this.usertags();
            result = result * 59 + ($usertags == null ? 43 : $usertags.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MediaConfigureTimelineRequest.MediaConfigurePayload(super=" + super.toString() + ", upload_id=" + this.upload_id() + ", caption=" + this.caption() + ", disable_comments=" + this.disable_comments() + ", location=" + this.location() + ", usertags=" + this.usertags() + ")";
        }

        public MediaConfigurePayload upload_id(String upload_id) {
            this.upload_id = upload_id;
            return this;
        }

        public MediaConfigurePayload caption(String caption) {
            this.caption = caption;
            return this;
        }

        public MediaConfigurePayload disable_comments(String disable_comments) {
            this.disable_comments = disable_comments;
            return this;
        }
    }
}

