/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.media;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGBaseModel;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.models.location.Location;
import com.github.instagram4j.instagram4j.models.media.UserTags;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.media.MediaResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class MediaConfigureSidecarRequest
extends IGPostRequest<MediaResponse.MediaConfigureSidecarResponse> {
    @NonNull
    private final MediaConfigureSidecarPayload payload;

    @Override
    protected IGPayload getPayload(IGClient client) {
        return this.payload;
    }

    @Override
    public String path() {
        return "media/configure_sidecar/";
    }

    @Override
    public Class<MediaResponse.MediaConfigureSidecarResponse> getResponseType() {
        return MediaResponse.MediaConfigureSidecarResponse.class;
    }

    public MediaConfigureSidecarRequest(@NonNull MediaConfigureSidecarPayload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.payload = payload;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class SidecarChildrenMetadata
    extends IGBaseModel {
        @NonNull
        private final String upload_id;
        private String usertags;

        public SidecarChildrenMetadata usertags(UserTags.UserTagPayload ... tags) {
            this.usertags = IGUtils.objectToJson(Collections.singletonMap("in", tags));
            return this;
        }

        public String usertag() {
            return this.usertags;
        }

        public SidecarChildrenMetadata(@NonNull String upload_id) {
            if (upload_id == null) {
                throw new NullPointerException("upload_id is marked non-null but is null");
            }
            this.upload_id = upload_id;
        }

        @NonNull
        public String upload_id() {
            return this.upload_id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SidecarChildrenMetadata)) {
                return false;
            }
            SidecarChildrenMetadata other = (SidecarChildrenMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$upload_id = this.upload_id();
            String other$upload_id = other.upload_id();
            if (this$upload_id == null ? other$upload_id != null : !this$upload_id.equals(other$upload_id)) {
                return false;
            }
            SidecarChildrenMetadata this$usertags = this.usertags(new UserTags.UserTagPayload[0]);
            SidecarChildrenMetadata other$usertags = other.usertags(new UserTags.UserTagPayload[0]);
            return !(this$usertags == null ? other$usertags != null : !((Object)this$usertags).equals(other$usertags));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SidecarChildrenMetadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $upload_id = this.upload_id();
            result = result * 59 + ($upload_id == null ? 43 : $upload_id.hashCode());
            SidecarChildrenMetadata $usertags = this.usertags(new UserTags.UserTagPayload[0]);
            result = result * 59 + ($usertags == null ? 43 : ((Object)$usertags).hashCode());
            return result;
        }

        public String toString() {
            return "MediaConfigureSidecarRequest.SidecarChildrenMetadata(super=" + super.toString() + ", upload_id=" + this.upload_id() + ", usertags=" + this.usertags(new UserTags.UserTagPayload[0]) + ")";
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class MediaConfigureSidecarPayload
    extends IGPayload {
        private List<SidecarChildrenMetadata> children_metadata = new ArrayList<SidecarChildrenMetadata>();
        private String caption = "";
        private String client_sidecar_id = String.valueOf(System.currentTimeMillis());
        private String location;
        private String disable_comments;

        public MediaConfigureSidecarPayload location(Location loc) {
            Location payloadLoc = new Location();
            payloadLoc.setExternal_id(loc.getExternal_id());
            payloadLoc.setName(loc.getName());
            payloadLoc.setAddress(loc.getAddress());
            payloadLoc.setLat(loc.getLat());
            payloadLoc.setLng(loc.getLng());
            payloadLoc.setExternal_source(loc.getExternal_source());
            payloadLoc.put(payloadLoc.getExternal_source() + "_id", payloadLoc.getExternal_id());
            this.location = IGUtils.objectToJson(payloadLoc);
            this.put("geotag_enabled", "1");
            this.put("posting_latitude", payloadLoc.getLat().toString());
            this.put("posting_longitude", payloadLoc.getLng().toString());
            this.put("media_latitude", payloadLoc.getLat().toString());
            this.put("media_longitude", payloadLoc.getLng().toString());
            return this;
        }

        public List<SidecarChildrenMetadata> children_metadata() {
            return this.children_metadata;
        }

        public String caption() {
            return this.caption;
        }

        public String client_sidecar_id() {
            return this.client_sidecar_id;
        }

        public String location() {
            return this.location;
        }

        public String disable_comments() {
            return this.disable_comments;
        }

        public MediaConfigureSidecarPayload children_metadata(List<SidecarChildrenMetadata> children_metadata) {
            this.children_metadata = children_metadata;
            return this;
        }

        public MediaConfigureSidecarPayload caption(String caption) {
            this.caption = caption;
            return this;
        }

        public MediaConfigureSidecarPayload client_sidecar_id(String client_sidecar_id) {
            this.client_sidecar_id = client_sidecar_id;
            return this;
        }

        public MediaConfigureSidecarPayload disable_comments(String disable_comments) {
            this.disable_comments = disable_comments;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MediaConfigureSidecarPayload)) {
                return false;
            }
            MediaConfigureSidecarPayload other = (MediaConfigureSidecarPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<SidecarChildrenMetadata> this$children_metadata = this.children_metadata();
            List<SidecarChildrenMetadata> other$children_metadata = other.children_metadata();
            if (this$children_metadata == null ? other$children_metadata != null : !((Object)this$children_metadata).equals(other$children_metadata)) {
                return false;
            }
            String this$caption = this.caption();
            String other$caption = other.caption();
            if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
                return false;
            }
            String this$client_sidecar_id = this.client_sidecar_id();
            String other$client_sidecar_id = other.client_sidecar_id();
            if (this$client_sidecar_id == null ? other$client_sidecar_id != null : !this$client_sidecar_id.equals(other$client_sidecar_id)) {
                return false;
            }
            String this$location = this.location();
            String other$location = other.location();
            if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                return false;
            }
            String this$disable_comments = this.disable_comments();
            String other$disable_comments = other.disable_comments();
            return !(this$disable_comments == null ? other$disable_comments != null : !this$disable_comments.equals(other$disable_comments));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MediaConfigureSidecarPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<SidecarChildrenMetadata> $children_metadata = this.children_metadata();
            result = result * 59 + ($children_metadata == null ? 43 : ((Object)$children_metadata).hashCode());
            String $caption = this.caption();
            result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
            String $client_sidecar_id = this.client_sidecar_id();
            result = result * 59 + ($client_sidecar_id == null ? 43 : $client_sidecar_id.hashCode());
            String $location = this.location();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            String $disable_comments = this.disable_comments();
            result = result * 59 + ($disable_comments == null ? 43 : $disable_comments.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MediaConfigureSidecarRequest.MediaConfigureSidecarPayload(super=" + super.toString() + ", children_metadata=" + this.children_metadata() + ", caption=" + this.caption() + ", client_sidecar_id=" + this.client_sidecar_id() + ", location=" + this.location() + ", disable_comments=" + this.disable_comments() + ")";
        }
    }
}

