/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.media;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.media.MediaCommentResponse;
import lombok.NonNull;

public class MediaCommentRequest
extends IGPostRequest<MediaCommentResponse> {
    @NonNull
    private String id;
    @NonNull
    private String _comment_text;
    private String _replied_to_comment_id;

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new MediaCommentPayload();
    }

    @Override
    public String path() {
        return "media/" + this.id + "/comment/";
    }

    @Override
    public Class<MediaCommentResponse> getResponseType() {
        return MediaCommentResponse.class;
    }

    public MediaCommentRequest(@NonNull String id, @NonNull String _comment_text) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (_comment_text == null) {
            throw new NullPointerException("_comment_text is marked non-null but is null");
        }
        this.id = id;
        this._comment_text = _comment_text;
    }

    public MediaCommentRequest(@NonNull String id, @NonNull String _comment_text, String _replied_to_comment_id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (_comment_text == null) {
            throw new NullPointerException("_comment_text is marked non-null but is null");
        }
        this.id = id;
        this._comment_text = _comment_text;
        this._replied_to_comment_id = _replied_to_comment_id;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private class MediaCommentPayload
    extends IGPayload {
        private String comment_text;
        private String replied_to_comment_id;

        public MediaCommentPayload() {
            this.comment_text = MediaCommentRequest.this._comment_text;
            this.replied_to_comment_id = MediaCommentRequest.this._replied_to_comment_id;
        }

        public String getComment_text() {
            return this.comment_text;
        }

        public String getReplied_to_comment_id() {
            return this.replied_to_comment_id;
        }

        public void setComment_text(String comment_text) {
            this.comment_text = comment_text;
        }

        public void setReplied_to_comment_id(String replied_to_comment_id) {
            this.replied_to_comment_id = replied_to_comment_id;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MediaCommentPayload)) {
                return false;
            }
            MediaCommentPayload other = (MediaCommentPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$comment_text = this.getComment_text();
            String other$comment_text = other.getComment_text();
            if (this$comment_text == null ? other$comment_text != null : !this$comment_text.equals(other$comment_text)) {
                return false;
            }
            String this$replied_to_comment_id = this.getReplied_to_comment_id();
            String other$replied_to_comment_id = other.getReplied_to_comment_id();
            return !(this$replied_to_comment_id == null ? other$replied_to_comment_id != null : !this$replied_to_comment_id.equals(other$replied_to_comment_id));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MediaCommentPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $comment_text = this.getComment_text();
            result = result * 59 + ($comment_text == null ? 43 : $comment_text.hashCode());
            String $replied_to_comment_id = this.getReplied_to_comment_id();
            result = result * 59 + ($replied_to_comment_id == null ? 43 : $replied_to_comment_id.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MediaCommentRequest.MediaCommentPayload(super=" + super.toString() + ", comment_text=" + this.getComment_text() + ", replied_to_comment_id=" + this.getReplied_to_comment_id() + ")";
        }
    }
}

