/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.media;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import lombok.NonNull;

public class MediaActionRequest
extends IGPostRequest<IGResponse> {
    @NonNull
    private String _media_id;
    @NonNull
    private MediaAction action;

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new IGPayload(){
            private String media_id;
            {
                this.media_id = MediaActionRequest.this._media_id;
            }

            public String getMedia_id() {
                return this.media_id;
            }
        };
    }

    @Override
    public String path() {
        return String.format("media/%s/%s/", this._media_id, this.action.name().toLowerCase());
    }

    @Override
    public Class<IGResponse> getResponseType() {
        return IGResponse.class;
    }

    public MediaActionRequest(@NonNull String _media_id, @NonNull MediaAction action) {
        if (_media_id == null) {
            throw new NullPointerException("_media_id is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this._media_id = _media_id;
        this.action = action;
    }

    public static enum MediaAction {
        SAVE,
        UNSAVE,
        ONLY_ME,
        UNDO_ONLY_ME,
        DELETE,
        LIKE,
        UNLIKE,
        ENABLE_COMMENTS,
        DISABLE_COMMENTS;

    }
}

