/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.live;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.live.LiveCreateResponse;

public class LiveCreateRequest
extends IGPostRequest<LiveCreateResponse> {
    private int width = 720;
    private int height = 1280;
    private String broadcastMessage = "test";
    private String broadcastType = "RTMP";

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new LiveCreatePayload(this.width, this.height, this.broadcastMessage, this.broadcastType);
    }

    @Override
    public String path() {
        return "live/create/";
    }

    @Override
    public Class<LiveCreateResponse> getResponseType() {
        return LiveCreateResponse.class;
    }

    public LiveCreateRequest() {
    }

    public LiveCreateRequest(int width, int height, String broadcastMessage, String broadcastType) {
        this.width = width;
        this.height = height;
        this.broadcastMessage = broadcastMessage;
        this.broadcastType = broadcastType;
    }

    public static class LiveCreatePayload
    extends IGPayload {
        private int preview_width;
        private int preview_height;
        private String broadcast_message;
        private String broadcast_type;

        public int getPreview_width() {
            return this.preview_width;
        }

        public int getPreview_height() {
            return this.preview_height;
        }

        public String getBroadcast_message() {
            return this.broadcast_message;
        }

        public String getBroadcast_type() {
            return this.broadcast_type;
        }

        public void setPreview_width(int preview_width) {
            this.preview_width = preview_width;
        }

        public void setPreview_height(int preview_height) {
            this.preview_height = preview_height;
        }

        public void setBroadcast_message(String broadcast_message) {
            this.broadcast_message = broadcast_message;
        }

        public void setBroadcast_type(String broadcast_type) {
            this.broadcast_type = broadcast_type;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LiveCreatePayload)) {
                return false;
            }
            LiveCreatePayload other = (LiveCreatePayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPreview_width() != other.getPreview_width()) {
                return false;
            }
            if (this.getPreview_height() != other.getPreview_height()) {
                return false;
            }
            String this$broadcast_message = this.getBroadcast_message();
            String other$broadcast_message = other.getBroadcast_message();
            if (this$broadcast_message == null ? other$broadcast_message != null : !this$broadcast_message.equals(other$broadcast_message)) {
                return false;
            }
            String this$broadcast_type = this.getBroadcast_type();
            String other$broadcast_type = other.getBroadcast_type();
            return !(this$broadcast_type == null ? other$broadcast_type != null : !this$broadcast_type.equals(other$broadcast_type));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof LiveCreatePayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPreview_width();
            result = result * 59 + this.getPreview_height();
            String $broadcast_message = this.getBroadcast_message();
            result = result * 59 + ($broadcast_message == null ? 43 : $broadcast_message.hashCode());
            String $broadcast_type = this.getBroadcast_type();
            result = result * 59 + ($broadcast_type == null ? 43 : $broadcast_type.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "LiveCreateRequest.LiveCreatePayload(super=" + super.toString() + ", preview_width=" + this.getPreview_width() + ", preview_height=" + this.getPreview_height() + ", broadcast_message=" + this.getBroadcast_message() + ", broadcast_type=" + this.getBroadcast_type() + ")";
        }

        public LiveCreatePayload(int preview_width, int preview_height, String broadcast_message, String broadcast_type) {
            this.preview_width = preview_width;
            this.preview_height = preview_height;
            this.broadcast_message = broadcast_message;
            this.broadcast_type = broadcast_type;
        }
    }
}

