/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.live;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.live.LiveBroadcastLikeResponse;
import lombok.NonNull;

public class LiveBroadcastLikeRequest
extends IGPostRequest<LiveBroadcastLikeResponse> {
    @NonNull
    private String broadcast_id;
    private int count = 1;

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new IGPayload(){
            private int user_like_count;
            {
                this.user_like_count = LiveBroadcastLikeRequest.this.count;
            }

            public int getUser_like_count() {
                return this.user_like_count;
            }
        };
    }

    @Override
    public String path() {
        return "live/" + this.broadcast_id + "/like/";
    }

    @Override
    public Class<LiveBroadcastLikeResponse> getResponseType() {
        return LiveBroadcastLikeResponse.class;
    }

    public LiveBroadcastLikeRequest(@NonNull String broadcast_id) {
        if (broadcast_id == null) {
            throw new NullPointerException("broadcast_id is marked non-null but is null");
        }
        this.broadcast_id = broadcast_id;
    }

    public LiveBroadcastLikeRequest(@NonNull String broadcast_id, int count) {
        if (broadcast_id == null) {
            throw new NullPointerException("broadcast_id is marked non-null but is null");
        }
        this.broadcast_id = broadcast_id;
        this.count = count;
    }
}

