/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.live;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.live.LiveBroadcastCommentResponse;
import lombok.NonNull;

public class LiveBroadcastCommentRequest
extends IGPostRequest<LiveBroadcastCommentResponse> {
    @NonNull
    private String broadcast_id;
    @NonNull
    private String _message;

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new LiveCommentPayload();
    }

    @Override
    public String path() {
        return "live/" + this.broadcast_id + "/comment/";
    }

    @Override
    public Class<LiveBroadcastCommentResponse> getResponseType() {
        return LiveBroadcastCommentResponse.class;
    }

    public LiveBroadcastCommentRequest(@NonNull String broadcast_id, @NonNull String _message) {
        if (broadcast_id == null) {
            throw new NullPointerException("broadcast_id is marked non-null but is null");
        }
        if (_message == null) {
            throw new NullPointerException("_message is marked non-null but is null");
        }
        this.broadcast_id = broadcast_id;
        this._message = _message;
    }

    public class LiveCommentPayload
    extends IGPayload {
        private String comment_text;

        public LiveCommentPayload() {
            this.comment_text = LiveBroadcastCommentRequest.this._message;
        }

        public String getComment_text() {
            return this.comment_text;
        }

        public void setComment_text(String comment_text) {
            this.comment_text = comment_text;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LiveCommentPayload)) {
                return false;
            }
            LiveCommentPayload other = (LiveCommentPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$comment_text = this.getComment_text();
            String other$comment_text = other.getComment_text();
            return !(this$comment_text == null ? other$comment_text != null : !this$comment_text.equals(other$comment_text));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof LiveCommentPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $comment_text = this.getComment_text();
            result = result * 59 + ($comment_text == null ? 43 : $comment_text.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "LiveBroadcastCommentRequest.LiveCommentPayload(super=" + super.toString() + ", comment_text=" + this.getComment_text() + ")";
        }
    }
}

