/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.igtv;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.igtv.IgtvSearchResponse;

public class IgtvSearchRequest
extends IGPostRequest<IgtvSearchResponse> {
    private String _query;

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new IgtvSearchPayload();
    }

    @Override
    public String path() {
        return String.format("igtv/%s/", this._query != null ? "search" : "suggested_searches");
    }

    @Override
    public Class<IgtvSearchResponse> getResponseType() {
        return IgtvSearchResponse.class;
    }

    public IgtvSearchRequest() {
    }

    public IgtvSearchRequest(String _query) {
        this._query = _query;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public class IgtvSearchPayload
    extends IGPayload {
        private String query;

        public IgtvSearchPayload() {
            this.query = IgtvSearchRequest.this._query;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IgtvSearchPayload)) {
                return false;
            }
            IgtvSearchPayload other = (IgtvSearchPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            return !(this$query == null ? other$query != null : !this$query.equals(other$query));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof IgtvSearchPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "IgtvSearchRequest.IgtvSearchPayload(super=" + super.toString() + ", query=" + this.getQuery() + ")";
        }
    }
}

