/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.friendships;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.requests.IGGetRequest;
import com.github.instagram4j.instagram4j.requests.IGPaginatedRequest;
import com.github.instagram4j.instagram4j.responses.feed.FeedUsersResponse;
import lombok.NonNull;

public class FriendshipsFeedsRequest
extends IGGetRequest<FeedUsersResponse>
implements IGPaginatedRequest {
    @NonNull
    private Long _id;
    @NonNull
    private FriendshipsFeeds action;
    private String max_id;

    @Override
    public String getQueryString(IGClient client) {
        return this.mapQueryString("max_id", this.max_id);
    }

    @Override
    public String path() {
        return String.format("friendships/%s/%s/", this._id, this.action.name().toLowerCase());
    }

    @Override
    public Class<FeedUsersResponse> getResponseType() {
        return FeedUsersResponse.class;
    }

    public FriendshipsFeedsRequest(@NonNull Long _id, @NonNull FriendshipsFeeds action) {
        if (_id == null) {
            throw new NullPointerException("_id is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this._id = _id;
        this.action = action;
    }

    public FriendshipsFeedsRequest(@NonNull Long _id, @NonNull FriendshipsFeeds action, String max_id) {
        if (_id == null) {
            throw new NullPointerException("_id is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this._id = _id;
        this.action = action;
        this.max_id = max_id;
    }

    @Override
    public void setMax_id(String max_id) {
        this.max_id = max_id;
    }

    public static enum FriendshipsFeeds {
        FOLLOWERS,
        FOLLOWING;

    }
}

