/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.friendships;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.friendships.FriendshipStatusResponse;
import lombok.NonNull;

public class FriendshipsActionRequest
extends IGPostRequest<FriendshipStatusResponse> {
    @NonNull
    private Long _pk;
    @NonNull
    private FriendshipsAction action;

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new IGPayload(){
            private long user_id;
            {
                this.user_id = FriendshipsActionRequest.this._pk;
            }

            public long getUser_id() {
                return this.user_id;
            }
        };
    }

    @Override
    public String path() {
        return String.format("friendships/%s/%s/", this.action.name().toLowerCase(), this._pk);
    }

    @Override
    public Class<FriendshipStatusResponse> getResponseType() {
        return FriendshipStatusResponse.class;
    }

    public FriendshipsActionRequest(@NonNull Long _pk, @NonNull FriendshipsAction action) {
        if (_pk == null) {
            throw new NullPointerException("_pk is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this._pk = _pk;
        this.action = action;
    }

    public static enum FriendshipsAction {
        BLOCK,
        UNBLOCK,
        CREATE,
        DESTROY,
        APPROVE,
        IGNORE,
        REMOVE_FOLLOWER;

    }
}

