/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.feed;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.requests.IGGetRequest;
import com.github.instagram4j.instagram4j.requests.IGPaginatedRequest;
import com.github.instagram4j.instagram4j.responses.feed.FeedTagResponse;
import lombok.NonNull;

public class FeedTagRequest
extends IGGetRequest<FeedTagResponse>
implements IGPaginatedRequest {
    @NonNull
    private String tag;
    private String max_id;

    @Override
    public String path() {
        return "feed/tag/" + this.tag + "/";
    }

    @Override
    public String getQueryString(IGClient client) {
        return this.mapQueryString("max_id", this.max_id);
    }

    @Override
    public Class<FeedTagResponse> getResponseType() {
        return FeedTagResponse.class;
    }

    public FeedTagRequest(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.tag = tag;
    }

    public FeedTagRequest(@NonNull String tag, String max_id) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.tag = tag;
        this.max_id = max_id;
    }

    @Override
    public void setMax_id(String max_id) {
        this.max_id = max_id;
    }
}

