/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.feed;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.requests.IGGetRequest;
import com.github.instagram4j.instagram4j.requests.IGPaginatedRequest;
import com.github.instagram4j.instagram4j.responses.feed.FeedLocationResponse;
import lombok.NonNull;

public class FeedLocationRequest
extends IGGetRequest<FeedLocationResponse>
implements IGPaginatedRequest {
    @NonNull
    private Long location;
    private String max_id;

    @Override
    public String path() {
        return "feed/location/" + this.location + "/";
    }

    @Override
    public String getQueryString(IGClient client) {
        return this.mapQueryString("max_id", this.max_id);
    }

    @Override
    public Class<FeedLocationResponse> getResponseType() {
        return FeedLocationResponse.class;
    }

    public FeedLocationRequest(@NonNull Long location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.location = location;
    }

    public FeedLocationRequest(@NonNull Long location, String max_id) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.location = location;
        this.max_id = max_id;
    }

    @Override
    public void setMax_id(String max_id) {
        this.max_id = max_id;
    }
}

