/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.direct;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import lombok.NonNull;

public class DirectThreadsMarkItemSeenRequest
extends IGPostRequest<IGResponse> {
    @NonNull
    private String _thread_id;
    @NonNull
    private String _item_id;

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new DirectThreadsMarkItemSeenPayload();
    }

    @Override
    public String path() {
        return String.format("direct_v2/threads/%s/items/%s/seen/", this._thread_id, this._item_id);
    }

    @Override
    public Class<IGResponse> getResponseType() {
        return IGResponse.class;
    }

    public DirectThreadsMarkItemSeenRequest(@NonNull String _thread_id, @NonNull String _item_id) {
        if (_thread_id == null) {
            throw new NullPointerException("_thread_id is marked non-null but is null");
        }
        if (_item_id == null) {
            throw new NullPointerException("_item_id is marked non-null but is null");
        }
        this._thread_id = _thread_id;
        this._item_id = _item_id;
    }

    public class DirectThreadsMarkItemSeenPayload
    extends IGPayload {
        private String thread_id;
        private String item_id;
        private final String action = "mark_seen";
        private boolean use_unified_inbox;

        public DirectThreadsMarkItemSeenPayload() {
            this.thread_id = DirectThreadsMarkItemSeenRequest.this._thread_id;
            this.item_id = DirectThreadsMarkItemSeenRequest.this._item_id;
            this.action = "mark_seen";
            this.use_unified_inbox = true;
        }

        public String getThread_id() {
            return this.thread_id;
        }

        public String getItem_id() {
            return this.item_id;
        }

        public String getAction() {
            return this.action;
        }

        public boolean isUse_unified_inbox() {
            return this.use_unified_inbox;
        }

        public void setThread_id(String thread_id) {
            this.thread_id = thread_id;
        }

        public void setItem_id(String item_id) {
            this.item_id = item_id;
        }

        public void setUse_unified_inbox(boolean use_unified_inbox) {
            this.use_unified_inbox = use_unified_inbox;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DirectThreadsMarkItemSeenPayload)) {
                return false;
            }
            DirectThreadsMarkItemSeenPayload other = (DirectThreadsMarkItemSeenPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$thread_id = this.getThread_id();
            String other$thread_id = other.getThread_id();
            if (this$thread_id == null ? other$thread_id != null : !this$thread_id.equals(other$thread_id)) {
                return false;
            }
            String this$item_id = this.getItem_id();
            String other$item_id = other.getItem_id();
            if (this$item_id == null ? other$item_id != null : !this$item_id.equals(other$item_id)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            return this.isUse_unified_inbox() == other.isUse_unified_inbox();
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof DirectThreadsMarkItemSeenPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $thread_id = this.getThread_id();
            result = result * 59 + ($thread_id == null ? 43 : $thread_id.hashCode());
            String $item_id = this.getItem_id();
            result = result * 59 + ($item_id == null ? 43 : $item_id.hashCode());
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            result = result * 59 + (this.isUse_unified_inbox() ? 79 : 97);
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsMarkItemSeenRequest.DirectThreadsMarkItemSeenPayload(super=" + super.toString() + ", thread_id=" + this.getThread_id() + ", item_id=" + this.getItem_id() + ", action=" + this.getAction() + ", use_unified_inbox=" + this.isUse_unified_inbox() + ")";
        }
    }
}

