/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.direct;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import java.util.Arrays;

public class DirectThreadsDeclineRequest
extends IGPostRequest<IGResponse> {
    private final String[] _thread_ids;

    public DirectThreadsDeclineRequest(String ... thread_ids) {
        this._thread_ids = thread_ids;
    }

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new DirectThreadsDeclineRequestPayload();
    }

    @Override
    public String path() {
        return String.format("direct_v2/threads/%s/", this._thread_ids.length > 1 ? "decline_multiple" : this._thread_ids[0] + "/decline");
    }

    @Override
    public Class<IGResponse> getResponseType() {
        return IGResponse.class;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public class DirectThreadsDeclineRequestPayload
    extends IGPayload {
        private final String[] thread_ids;

        public DirectThreadsDeclineRequestPayload() {
            this.thread_ids = DirectThreadsDeclineRequest.this._thread_ids.length > 1 ? DirectThreadsDeclineRequest.this._thread_ids : null;
        }

        public String[] getThread_ids() {
            return this.thread_ids;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DirectThreadsDeclineRequestPayload)) {
                return false;
            }
            DirectThreadsDeclineRequestPayload other = (DirectThreadsDeclineRequestPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.deepEquals(this.getThread_ids(), other.getThread_ids());
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof DirectThreadsDeclineRequestPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getThread_ids());
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsDeclineRequest.DirectThreadsDeclineRequestPayload(super=" + super.toString() + ", thread_ids=" + Arrays.deepToString(this.getThread_ids()) + ")";
        }
    }
}

