/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.direct;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import java.util.Arrays;
import lombok.NonNull;

public class DirectThreadsBroadcastRequest
extends IGPostRequest<IGResponse> {
    @NonNull
    private final BroadcastPayload payload;

    @Override
    protected IGPayload getPayload(IGClient client) {
        return this.payload;
    }

    @Override
    public String path() {
        return "direct_v2/threads/broadcast/" + this.payload.getItemType() + "/";
    }

    @Override
    public Class<IGResponse> getResponseType() {
        return IGResponse.class;
    }

    public DirectThreadsBroadcastRequest(@NonNull BroadcastPayload payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.payload = payload;
    }

    public static class BroadcastLinkPayload
    extends BroadcastPayload {
        private final String thread_ids;
        private final String recipient_users;
        private final String link_text;
        private final String link_urls;

        public BroadcastLinkPayload(String text, String[] link_urls, long ... pks) {
            this.thread_ids = null;
            this.recipient_users = IGUtils.objectToJson(Arrays.asList(new long[][]{pks}));
            this.link_text = text;
            this.link_urls = IGUtils.objectToJson(link_urls);
        }

        public BroadcastLinkPayload(String text, String[] link_urls, String ... thread_ids) {
            this.thread_ids = IGUtils.objectToJson(thread_ids);
            this.recipient_users = null;
            this.link_text = text;
            this.link_urls = IGUtils.objectToJson(link_urls);
        }

        @Override
        public String getItemType() {
            return "link";
        }

        @Override
        public String getThread_ids() {
            return this.thread_ids;
        }

        @Override
        public String getRecipient_users() {
            return this.recipient_users;
        }

        public String getLink_text() {
            return this.link_text;
        }

        public String getLink_urls() {
            return this.link_urls;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroadcastLinkPayload)) {
                return false;
            }
            BroadcastLinkPayload other = (BroadcastLinkPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$thread_ids = this.getThread_ids();
            String other$thread_ids = other.getThread_ids();
            if (this$thread_ids == null ? other$thread_ids != null : !this$thread_ids.equals(other$thread_ids)) {
                return false;
            }
            String this$recipient_users = this.getRecipient_users();
            String other$recipient_users = other.getRecipient_users();
            if (this$recipient_users == null ? other$recipient_users != null : !this$recipient_users.equals(other$recipient_users)) {
                return false;
            }
            String this$link_text = this.getLink_text();
            String other$link_text = other.getLink_text();
            if (this$link_text == null ? other$link_text != null : !this$link_text.equals(other$link_text)) {
                return false;
            }
            String this$link_urls = this.getLink_urls();
            String other$link_urls = other.getLink_urls();
            return !(this$link_urls == null ? other$link_urls != null : !this$link_urls.equals(other$link_urls));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BroadcastLinkPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $thread_ids = this.getThread_ids();
            result = result * 59 + ($thread_ids == null ? 43 : $thread_ids.hashCode());
            String $recipient_users = this.getRecipient_users();
            result = result * 59 + ($recipient_users == null ? 43 : $recipient_users.hashCode());
            String $link_text = this.getLink_text();
            result = result * 59 + ($link_text == null ? 43 : $link_text.hashCode());
            String $link_urls = this.getLink_urls();
            result = result * 59 + ($link_urls == null ? 43 : $link_urls.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsBroadcastRequest.BroadcastLinkPayload(super=" + super.toString() + ", thread_ids=" + this.getThread_ids() + ", recipient_users=" + this.getRecipient_users() + ", link_text=" + this.getLink_text() + ", link_urls=" + this.getLink_urls() + ")";
        }
    }

    public static class BroadcastConfigureVideoPayload
    extends BroadcastPayload {
        private final String thread_ids;
        private final String recipient_users;
        private final String upload_id;

        public BroadcastConfigureVideoPayload(String upload_id, long ... pks) {
            this.thread_ids = null;
            this.recipient_users = IGUtils.objectToJson(Arrays.asList(new long[][]{pks}));
            this.upload_id = upload_id;
        }

        public BroadcastConfigureVideoPayload(String upload_id, String ... thread_ids) {
            this.thread_ids = IGUtils.objectToJson(thread_ids);
            this.recipient_users = null;
            this.upload_id = upload_id;
        }

        @Override
        public String getItemType() {
            return "configure_video";
        }

        @Override
        public String getThread_ids() {
            return this.thread_ids;
        }

        @Override
        public String getRecipient_users() {
            return this.recipient_users;
        }

        public String getUpload_id() {
            return this.upload_id;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroadcastConfigureVideoPayload)) {
                return false;
            }
            BroadcastConfigureVideoPayload other = (BroadcastConfigureVideoPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$thread_ids = this.getThread_ids();
            String other$thread_ids = other.getThread_ids();
            if (this$thread_ids == null ? other$thread_ids != null : !this$thread_ids.equals(other$thread_ids)) {
                return false;
            }
            String this$recipient_users = this.getRecipient_users();
            String other$recipient_users = other.getRecipient_users();
            if (this$recipient_users == null ? other$recipient_users != null : !this$recipient_users.equals(other$recipient_users)) {
                return false;
            }
            String this$upload_id = this.getUpload_id();
            String other$upload_id = other.getUpload_id();
            return !(this$upload_id == null ? other$upload_id != null : !this$upload_id.equals(other$upload_id));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BroadcastConfigureVideoPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $thread_ids = this.getThread_ids();
            result = result * 59 + ($thread_ids == null ? 43 : $thread_ids.hashCode());
            String $recipient_users = this.getRecipient_users();
            result = result * 59 + ($recipient_users == null ? 43 : $recipient_users.hashCode());
            String $upload_id = this.getUpload_id();
            result = result * 59 + ($upload_id == null ? 43 : $upload_id.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsBroadcastRequest.BroadcastConfigureVideoPayload(super=" + super.toString() + ", thread_ids=" + this.getThread_ids() + ", recipient_users=" + this.getRecipient_users() + ", upload_id=" + this.getUpload_id() + ")";
        }
    }

    public static class BroadcastConfigurePhotoPayload
    extends BroadcastPayload {
        private final String thread_ids;
        private final String recipient_users;
        private final String upload_id;

        public BroadcastConfigurePhotoPayload(String upload_id, long ... pks) {
            this.thread_ids = null;
            this.recipient_users = IGUtils.objectToJson(Arrays.asList(new long[][]{pks}));
            this.upload_id = upload_id;
        }

        public BroadcastConfigurePhotoPayload(String upload_id, String ... thread_ids) {
            this.thread_ids = IGUtils.objectToJson(thread_ids);
            this.recipient_users = null;
            this.upload_id = upload_id;
        }

        @Override
        public String getItemType() {
            return "configure_photo";
        }

        @Override
        public String getThread_ids() {
            return this.thread_ids;
        }

        @Override
        public String getRecipient_users() {
            return this.recipient_users;
        }

        public String getUpload_id() {
            return this.upload_id;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroadcastConfigurePhotoPayload)) {
                return false;
            }
            BroadcastConfigurePhotoPayload other = (BroadcastConfigurePhotoPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$thread_ids = this.getThread_ids();
            String other$thread_ids = other.getThread_ids();
            if (this$thread_ids == null ? other$thread_ids != null : !this$thread_ids.equals(other$thread_ids)) {
                return false;
            }
            String this$recipient_users = this.getRecipient_users();
            String other$recipient_users = other.getRecipient_users();
            if (this$recipient_users == null ? other$recipient_users != null : !this$recipient_users.equals(other$recipient_users)) {
                return false;
            }
            String this$upload_id = this.getUpload_id();
            String other$upload_id = other.getUpload_id();
            return !(this$upload_id == null ? other$upload_id != null : !this$upload_id.equals(other$upload_id));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BroadcastConfigurePhotoPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $thread_ids = this.getThread_ids();
            result = result * 59 + ($thread_ids == null ? 43 : $thread_ids.hashCode());
            String $recipient_users = this.getRecipient_users();
            result = result * 59 + ($recipient_users == null ? 43 : $recipient_users.hashCode());
            String $upload_id = this.getUpload_id();
            result = result * 59 + ($upload_id == null ? 43 : $upload_id.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsBroadcastRequest.BroadcastConfigurePhotoPayload(super=" + super.toString() + ", thread_ids=" + this.getThread_ids() + ", recipient_users=" + this.getRecipient_users() + ", upload_id=" + this.getUpload_id() + ")";
        }
    }

    public static class BroadcastProfilePayload
    extends BroadcastPayload {
        private final String thread_ids;
        private final String recipient_users;
        private final String profile_user_id;

        public BroadcastProfilePayload(String user_id, long ... pks) {
            this.thread_ids = null;
            this.recipient_users = IGUtils.objectToJson(Arrays.asList(new long[][]{pks}));
            this.profile_user_id = user_id;
        }

        public BroadcastProfilePayload(String user_id, String ... thread_ids) {
            this.thread_ids = IGUtils.objectToJson(thread_ids);
            this.recipient_users = null;
            this.profile_user_id = user_id;
        }

        @Override
        public String getItemType() {
            return "profile";
        }

        @Override
        public String getThread_ids() {
            return this.thread_ids;
        }

        @Override
        public String getRecipient_users() {
            return this.recipient_users;
        }

        public String getProfile_user_id() {
            return this.profile_user_id;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroadcastProfilePayload)) {
                return false;
            }
            BroadcastProfilePayload other = (BroadcastProfilePayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$thread_ids = this.getThread_ids();
            String other$thread_ids = other.getThread_ids();
            if (this$thread_ids == null ? other$thread_ids != null : !this$thread_ids.equals(other$thread_ids)) {
                return false;
            }
            String this$recipient_users = this.getRecipient_users();
            String other$recipient_users = other.getRecipient_users();
            if (this$recipient_users == null ? other$recipient_users != null : !this$recipient_users.equals(other$recipient_users)) {
                return false;
            }
            String this$profile_user_id = this.getProfile_user_id();
            String other$profile_user_id = other.getProfile_user_id();
            return !(this$profile_user_id == null ? other$profile_user_id != null : !this$profile_user_id.equals(other$profile_user_id));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BroadcastProfilePayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $thread_ids = this.getThread_ids();
            result = result * 59 + ($thread_ids == null ? 43 : $thread_ids.hashCode());
            String $recipient_users = this.getRecipient_users();
            result = result * 59 + ($recipient_users == null ? 43 : $recipient_users.hashCode());
            String $profile_user_id = this.getProfile_user_id();
            result = result * 59 + ($profile_user_id == null ? 43 : $profile_user_id.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsBroadcastRequest.BroadcastProfilePayload(super=" + super.toString() + ", thread_ids=" + this.getThread_ids() + ", recipient_users=" + this.getRecipient_users() + ", profile_user_id=" + this.getProfile_user_id() + ")";
        }
    }

    public static class BroadcastShareVoicePayload
    extends BroadcastPayload {
        private final String thread_ids;
        private final String recipient_users;
        private final String upload_id;
        private String waveform = IGUtils.objectToJson(new double[]{0.146, 0.5, 0.854, 1.0, 0.854, 0.5, 0.146, 0.0, 0.146, 0.5, 0.854, 1.0, 0.854, 0.5, 0.146, 0.0, 0.146, 0.5, 0.854, 1.0});
        private int waveform_sampling_frequency_hz = 10;

        public BroadcastShareVoicePayload(String upload_id, long ... pks) {
            this.thread_ids = null;
            this.recipient_users = IGUtils.objectToJson(Arrays.asList(new long[][]{pks}));
            this.upload_id = upload_id;
        }

        public BroadcastShareVoicePayload(String upload_id, String ... upload_ids) {
            this.thread_ids = IGUtils.objectToJson(upload_ids);
            this.recipient_users = null;
            this.upload_id = upload_id;
        }

        @Override
        public String getItemType() {
            return "share_voice";
        }

        @Override
        public String getThread_ids() {
            return this.thread_ids;
        }

        @Override
        public String getRecipient_users() {
            return this.recipient_users;
        }

        public String getUpload_id() {
            return this.upload_id;
        }

        public String getWaveform() {
            return this.waveform;
        }

        public int getWaveform_sampling_frequency_hz() {
            return this.waveform_sampling_frequency_hz;
        }

        public void setWaveform(String waveform) {
            this.waveform = waveform;
        }

        public void setWaveform_sampling_frequency_hz(int waveform_sampling_frequency_hz) {
            this.waveform_sampling_frequency_hz = waveform_sampling_frequency_hz;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroadcastShareVoicePayload)) {
                return false;
            }
            BroadcastShareVoicePayload other = (BroadcastShareVoicePayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$thread_ids = this.getThread_ids();
            String other$thread_ids = other.getThread_ids();
            if (this$thread_ids == null ? other$thread_ids != null : !this$thread_ids.equals(other$thread_ids)) {
                return false;
            }
            String this$recipient_users = this.getRecipient_users();
            String other$recipient_users = other.getRecipient_users();
            if (this$recipient_users == null ? other$recipient_users != null : !this$recipient_users.equals(other$recipient_users)) {
                return false;
            }
            String this$upload_id = this.getUpload_id();
            String other$upload_id = other.getUpload_id();
            if (this$upload_id == null ? other$upload_id != null : !this$upload_id.equals(other$upload_id)) {
                return false;
            }
            String this$waveform = this.getWaveform();
            String other$waveform = other.getWaveform();
            if (this$waveform == null ? other$waveform != null : !this$waveform.equals(other$waveform)) {
                return false;
            }
            return this.getWaveform_sampling_frequency_hz() == other.getWaveform_sampling_frequency_hz();
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BroadcastShareVoicePayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $thread_ids = this.getThread_ids();
            result = result * 59 + ($thread_ids == null ? 43 : $thread_ids.hashCode());
            String $recipient_users = this.getRecipient_users();
            result = result * 59 + ($recipient_users == null ? 43 : $recipient_users.hashCode());
            String $upload_id = this.getUpload_id();
            result = result * 59 + ($upload_id == null ? 43 : $upload_id.hashCode());
            String $waveform = this.getWaveform();
            result = result * 59 + ($waveform == null ? 43 : $waveform.hashCode());
            result = result * 59 + this.getWaveform_sampling_frequency_hz();
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsBroadcastRequest.BroadcastShareVoicePayload(super=" + super.toString() + ", thread_ids=" + this.getThread_ids() + ", recipient_users=" + this.getRecipient_users() + ", upload_id=" + this.getUpload_id() + ", waveform=" + this.getWaveform() + ", waveform_sampling_frequency_hz=" + this.getWaveform_sampling_frequency_hz() + ")";
        }

        public BroadcastShareVoicePayload(String thread_ids, String recipient_users, String upload_id, String waveform, int waveform_sampling_frequency_hz) {
            this.thread_ids = thread_ids;
            this.recipient_users = recipient_users;
            this.upload_id = upload_id;
            this.waveform = waveform;
            this.waveform_sampling_frequency_hz = waveform_sampling_frequency_hz;
        }
    }

    public static class BroadcastStorySharePayload
    extends BroadcastPayload {
        private final String thread_ids;
        private final String recipient_users;
        private final String story_media_id;
        private final String text;

        public BroadcastStorySharePayload(String media_id, String text, long ... pks) {
            this.thread_ids = null;
            this.recipient_users = IGUtils.objectToJson(Arrays.asList(new long[][]{pks}));
            this.story_media_id = media_id;
            this.text = text;
        }

        public BroadcastStorySharePayload(String media_id, String text, String ... thread_ids) {
            this.thread_ids = IGUtils.objectToJson(thread_ids);
            this.recipient_users = null;
            this.story_media_id = media_id;
            this.text = text;
        }

        @Override
        public String getItemType() {
            return "story_share";
        }

        @Override
        public String getThread_ids() {
            return this.thread_ids;
        }

        @Override
        public String getRecipient_users() {
            return this.recipient_users;
        }

        public String getStory_media_id() {
            return this.story_media_id;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroadcastStorySharePayload)) {
                return false;
            }
            BroadcastStorySharePayload other = (BroadcastStorySharePayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$thread_ids = this.getThread_ids();
            String other$thread_ids = other.getThread_ids();
            if (this$thread_ids == null ? other$thread_ids != null : !this$thread_ids.equals(other$thread_ids)) {
                return false;
            }
            String this$recipient_users = this.getRecipient_users();
            String other$recipient_users = other.getRecipient_users();
            if (this$recipient_users == null ? other$recipient_users != null : !this$recipient_users.equals(other$recipient_users)) {
                return false;
            }
            String this$story_media_id = this.getStory_media_id();
            String other$story_media_id = other.getStory_media_id();
            if (this$story_media_id == null ? other$story_media_id != null : !this$story_media_id.equals(other$story_media_id)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BroadcastStorySharePayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $thread_ids = this.getThread_ids();
            result = result * 59 + ($thread_ids == null ? 43 : $thread_ids.hashCode());
            String $recipient_users = this.getRecipient_users();
            result = result * 59 + ($recipient_users == null ? 43 : $recipient_users.hashCode());
            String $story_media_id = this.getStory_media_id();
            result = result * 59 + ($story_media_id == null ? 43 : $story_media_id.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsBroadcastRequest.BroadcastStorySharePayload(super=" + super.toString() + ", thread_ids=" + this.getThread_ids() + ", recipient_users=" + this.getRecipient_users() + ", story_media_id=" + this.getStory_media_id() + ", text=" + this.getText() + ")";
        }
    }

    public static class BroadcastReelSharePayload
    extends BroadcastPayload {
        private final String thread_ids;
        private final String recipient_users;
        private final String text;
        private final String media_id;

        public BroadcastReelSharePayload(String media_id, String text, long ... pks) {
            this.thread_ids = null;
            this.recipient_users = IGUtils.objectToJson(Arrays.asList(new long[][]{pks}));
            this.media_id = media_id;
            this.text = text;
        }

        public BroadcastReelSharePayload(String media_id, String text, String ... thread_ids) {
            this.thread_ids = IGUtils.objectToJson(thread_ids);
            this.recipient_users = null;
            this.media_id = media_id;
            this.text = text;
        }

        @Override
        public String getItemType() {
            return "reel_share";
        }

        @Override
        public String getThread_ids() {
            return this.thread_ids;
        }

        @Override
        public String getRecipient_users() {
            return this.recipient_users;
        }

        public String getText() {
            return this.text;
        }

        public String getMedia_id() {
            return this.media_id;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroadcastReelSharePayload)) {
                return false;
            }
            BroadcastReelSharePayload other = (BroadcastReelSharePayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$thread_ids = this.getThread_ids();
            String other$thread_ids = other.getThread_ids();
            if (this$thread_ids == null ? other$thread_ids != null : !this$thread_ids.equals(other$thread_ids)) {
                return false;
            }
            String this$recipient_users = this.getRecipient_users();
            String other$recipient_users = other.getRecipient_users();
            if (this$recipient_users == null ? other$recipient_users != null : !this$recipient_users.equals(other$recipient_users)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$media_id = this.getMedia_id();
            String other$media_id = other.getMedia_id();
            return !(this$media_id == null ? other$media_id != null : !this$media_id.equals(other$media_id));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BroadcastReelSharePayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $thread_ids = this.getThread_ids();
            result = result * 59 + ($thread_ids == null ? 43 : $thread_ids.hashCode());
            String $recipient_users = this.getRecipient_users();
            result = result * 59 + ($recipient_users == null ? 43 : $recipient_users.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $media_id = this.getMedia_id();
            result = result * 59 + ($media_id == null ? 43 : $media_id.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsBroadcastRequest.BroadcastReelSharePayload(super=" + super.toString() + ", thread_ids=" + this.getThread_ids() + ", recipient_users=" + this.getRecipient_users() + ", text=" + this.getText() + ", media_id=" + this.getMedia_id() + ")";
        }
    }

    public static class BroadcastMediaSharePayload
    extends BroadcastPayload {
        private final String thread_ids;
        private final String recipient_users;
        private final String text;
        private final String media_id;

        public BroadcastMediaSharePayload(String media_id, String text, long ... pks) {
            this.thread_ids = null;
            this.recipient_users = IGUtils.objectToJson(Arrays.asList(new long[][]{pks}));
            this.media_id = media_id;
            this.text = text;
        }

        public BroadcastMediaSharePayload(String media_id, String text, String ... thread_ids) {
            this.thread_ids = IGUtils.objectToJson(thread_ids);
            this.recipient_users = null;
            this.media_id = media_id;
            this.text = text;
        }

        @Override
        public String getItemType() {
            return "media_share";
        }

        @Override
        public String getThread_ids() {
            return this.thread_ids;
        }

        @Override
        public String getRecipient_users() {
            return this.recipient_users;
        }

        public String getText() {
            return this.text;
        }

        public String getMedia_id() {
            return this.media_id;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroadcastMediaSharePayload)) {
                return false;
            }
            BroadcastMediaSharePayload other = (BroadcastMediaSharePayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$thread_ids = this.getThread_ids();
            String other$thread_ids = other.getThread_ids();
            if (this$thread_ids == null ? other$thread_ids != null : !this$thread_ids.equals(other$thread_ids)) {
                return false;
            }
            String this$recipient_users = this.getRecipient_users();
            String other$recipient_users = other.getRecipient_users();
            if (this$recipient_users == null ? other$recipient_users != null : !this$recipient_users.equals(other$recipient_users)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$media_id = this.getMedia_id();
            String other$media_id = other.getMedia_id();
            return !(this$media_id == null ? other$media_id != null : !this$media_id.equals(other$media_id));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BroadcastMediaSharePayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $thread_ids = this.getThread_ids();
            result = result * 59 + ($thread_ids == null ? 43 : $thread_ids.hashCode());
            String $recipient_users = this.getRecipient_users();
            result = result * 59 + ($recipient_users == null ? 43 : $recipient_users.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $media_id = this.getMedia_id();
            result = result * 59 + ($media_id == null ? 43 : $media_id.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsBroadcastRequest.BroadcastMediaSharePayload(super=" + super.toString() + ", thread_ids=" + this.getThread_ids() + ", recipient_users=" + this.getRecipient_users() + ", text=" + this.getText() + ", media_id=" + this.getMedia_id() + ")";
        }
    }

    public static class BroadcastTextPayload
    extends BroadcastPayload {
        private final String thread_ids;
        private final String recipient_users;
        private final String text;

        public BroadcastTextPayload(String text, long ... pks) {
            this.thread_ids = null;
            this.recipient_users = IGUtils.objectToJson(Arrays.asList(new long[][]{pks}));
            this.text = text;
        }

        public BroadcastTextPayload(String text, String ... thread_ids) {
            this.thread_ids = IGUtils.objectToJson(thread_ids);
            this.recipient_users = null;
            this.text = text;
        }

        @Override
        public String getItemType() {
            return "text";
        }

        @Override
        public String getThread_ids() {
            return this.thread_ids;
        }

        @Override
        public String getRecipient_users() {
            return this.recipient_users;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroadcastTextPayload)) {
                return false;
            }
            BroadcastTextPayload other = (BroadcastTextPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$thread_ids = this.getThread_ids();
            String other$thread_ids = other.getThread_ids();
            if (this$thread_ids == null ? other$thread_ids != null : !this$thread_ids.equals(other$thread_ids)) {
                return false;
            }
            String this$recipient_users = this.getRecipient_users();
            String other$recipient_users = other.getRecipient_users();
            if (this$recipient_users == null ? other$recipient_users != null : !this$recipient_users.equals(other$recipient_users)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BroadcastTextPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $thread_ids = this.getThread_ids();
            result = result * 59 + ($thread_ids == null ? 43 : $thread_ids.hashCode());
            String $recipient_users = this.getRecipient_users();
            result = result * 59 + ($recipient_users == null ? 43 : $recipient_users.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsBroadcastRequest.BroadcastTextPayload(super=" + super.toString() + ", thread_ids=" + this.getThread_ids() + ", recipient_users=" + this.getRecipient_users() + ", text=" + this.getText() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static abstract class BroadcastPayload
    extends IGPayload {
        private String action = "send_item";

        @JsonIgnore
        public abstract String getItemType();

        public abstract String getThread_ids();

        public abstract String getRecipient_users();

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroadcastPayload)) {
                return false;
            }
            BroadcastPayload other = (BroadcastPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            return !(this$action == null ? other$action != null : !this$action.equals(other$action));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BroadcastPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "DirectThreadsBroadcastRequest.BroadcastPayload(super=" + super.toString() + ", action=" + this.getAction() + ")";
        }
    }
}

