/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.direct;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import lombok.NonNull;

public class DirectThreadsActionRequest
extends IGPostRequest<IGResponse> {
    @NonNull
    private String thread_id;
    @NonNull
    private DirectThreadsAction action;

    @Override
    protected IGPayload getPayload(IGClient client) {
        return new IGPayload();
    }

    @Override
    public String path() {
        return String.format("direct_v2/threads/%s/%s/", this.thread_id, this.action.name().toLowerCase());
    }

    @Override
    public Class<IGResponse> getResponseType() {
        return IGResponse.class;
    }

    public DirectThreadsActionRequest(@NonNull String thread_id, @NonNull DirectThreadsAction action) {
        if (thread_id == null) {
            throw new NullPointerException("thread_id is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.thread_id = thread_id;
        this.action = action;
    }

    public static enum DirectThreadsAction {
        HIDE,
        MUTE,
        UNMUTE,
        LEAVE;

    }
}

