/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.commerce;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.requests.IGGetRequest;
import com.github.instagram4j.instagram4j.responses.commerce.CommerceProductsDetailsResponse;
import lombok.NonNull;

public class CommerceProductsDetailsRequest
extends IGGetRequest<CommerceProductsDetailsResponse> {
    @NonNull
    private String product_id;
    @NonNull
    private String merchant_id;

    @Override
    public String path() {
        return "commerce/products/" + this.product_id + "/details/";
    }

    @Override
    public String getQueryString(IGClient client) {
        return this.mapQueryString("merchant_id", this.merchant_id);
    }

    @Override
    public Class<CommerceProductsDetailsResponse> getResponseType() {
        return CommerceProductsDetailsResponse.class;
    }

    public CommerceProductsDetailsRequest(@NonNull String product_id, @NonNull String merchant_id) {
        if (product_id == null) {
            throw new NullPointerException("product_id is marked non-null but is null");
        }
        if (merchant_id == null) {
            throw new NullPointerException("merchant_id is marked non-null but is null");
        }
        this.product_id = product_id;
        this.merchant_id = merchant_id;
    }
}

