/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.accounts;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.requests.accounts.AccountsLoginRequest;
import com.github.instagram4j.instagram4j.responses.accounts.LoginResponse;
import lombok.NonNull;

public class AccountsTwoFactorLoginRequest
extends IGPostRequest<LoginResponse> {
    @NonNull
    private String username;
    @NonNull
    private String password;
    @NonNull
    private String code;
    @NonNull
    private String identifier;

    @Override
    public IGPayload getPayload(IGClient client) {
        return new AccountsLoginRequest.LoginPayload(this.username, this.password){
            private final String verification_code;
            private final String two_factor_identifier;
            {
                this.verification_code = AccountsTwoFactorLoginRequest.this.code;
                this.two_factor_identifier = AccountsTwoFactorLoginRequest.this.identifier;
            }

            public String getVerification_code() {
                return this.verification_code;
            }

            public String getTwo_factor_identifier() {
                return this.two_factor_identifier;
            }
        };
    }

    @Override
    public String path() {
        return "accounts/two_factor_login/";
    }

    @Override
    public Class<LoginResponse> getResponseType() {
        return LoginResponse.class;
    }

    public AccountsTwoFactorLoginRequest(@NonNull String username, @NonNull String password, @NonNull String code, @NonNull String identifier) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        this.username = username;
        this.password = password;
        this.code = code;
        this.identifier = identifier;
    }
}

