/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests.accounts;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGPostRequest;
import com.github.instagram4j.instagram4j.responses.accounts.LoginResponse;
import lombok.NonNull;

public class AccountsLoginRequest
extends IGPostRequest<LoginResponse> {
    @NonNull
    private String username;
    @NonNull
    private String password;

    @Override
    public String path() {
        return "accounts/login/";
    }

    @Override
    public IGPayload getPayload(IGClient client) {
        return new LoginPayload(this.username, this.password);
    }

    @Override
    public Class<LoginResponse> getResponseType() {
        return LoginResponse.class;
    }

    public AccountsLoginRequest(@NonNull String username, @NonNull String password) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.username = username;
        this.password = password;
    }

    public static class LoginPayload
    extends IGPayload {
        @NonNull
        private String username;
        @NonNull
        private String enc_password;
        private int login_attempt_account = 0;

        public LoginPayload(@NonNull String username, @NonNull String enc_password) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            if (enc_password == null) {
                throw new NullPointerException("enc_password is marked non-null but is null");
            }
            this.username = username;
            this.enc_password = enc_password;
        }

        @NonNull
        public String getUsername() {
            return this.username;
        }

        @NonNull
        public String getEnc_password() {
            return this.enc_password;
        }

        public int getLogin_attempt_account() {
            return this.login_attempt_account;
        }

        public void setUsername(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
        }

        public void setEnc_password(@NonNull String enc_password) {
            if (enc_password == null) {
                throw new NullPointerException("enc_password is marked non-null but is null");
            }
            this.enc_password = enc_password;
        }

        public void setLogin_attempt_account(int login_attempt_account) {
            this.login_attempt_account = login_attempt_account;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoginPayload)) {
                return false;
            }
            LoginPayload other = (LoginPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$enc_password = this.getEnc_password();
            String other$enc_password = other.getEnc_password();
            if (this$enc_password == null ? other$enc_password != null : !this$enc_password.equals(other$enc_password)) {
                return false;
            }
            return this.getLogin_attempt_account() == other.getLogin_attempt_account();
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof LoginPayload;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $enc_password = this.getEnc_password();
            result = result * 59 + ($enc_password == null ? 43 : $enc_password.hashCode());
            result = result * 59 + this.getLogin_attempt_account();
            return result;
        }

        @Override
        public String toString() {
            return "AccountsLoginRequest.LoginPayload(super=" + super.toString() + ", username=" + this.getUsername() + ", enc_password=" + this.getEnc_password() + ", login_attempt_account=" + this.getLogin_attempt_account() + ")";
        }
    }
}

