/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.exceptions.IGResponseException;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import java.net.URLEncoder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Pair;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IGRequest<T extends IGResponse> {
    private static final Logger log = LoggerFactory.getLogger(IGRequest.class);

    public abstract String path();

    public abstract Request formRequest(IGClient var1);

    public abstract Class<T> getResponseType();

    public String apiPath() {
        return "api/v1/";
    }

    public String baseApiUrl() {
        return "https://i.instagram.com/";
    }

    public String getQueryString(IGClient client) {
        return "";
    }

    public HttpUrl formUrl(IGClient client) {
        return HttpUrl.parse((String)(this.baseApiUrl() + this.apiPath() + this.path() + this.getQueryString(client)));
    }

    public CompletableFuture<T> execute(IGClient client) {
        return client.sendRequest(this);
    }

    protected String mapQueryString(Object ... strings) {
        StringBuilder builder = new StringBuilder("?");
        for (int i = 0; i < strings.length; i += 2) {
            if (i + 1 >= strings.length || strings[i] == null || strings[i + 1] == null || strings[i].toString().isEmpty() || strings[i + 1].toString().isEmpty()) continue;
            builder.append(URLEncoder.encode(strings[i].toString(), "utf-8")).append("=").append(URLEncoder.encode(strings[i + 1].toString(), "utf-8")).append("&");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public T parseResponse(Pair<Response, String> response) {
        T igResponse = this.parseResponse((String)response.getSecond());
        ((IGResponse)igResponse).setStatusCode(((Response)response.getFirst()).code());
        if (!((Response)response.getFirst()).isSuccessful() || ((IGResponse)igResponse).getStatus() != null && ((IGResponse)igResponse).getStatus().equals("fail")) {
            throw new IGResponseException((IGResponse)igResponse);
        }
        return igResponse;
    }

    public T parseResponse(String json) throws JsonProcessingException {
        return (T)((IGResponse)this.parseResponse(json, this.getResponseType()));
    }

    public <U> U parseResponse(String json, Class<U> type) throws JsonProcessingException {
        log.debug("{} parsing response : {}", (Object)(this.apiPath() + this.path()), (Object)json);
        U response = IGUtils.jsonToObject(json, type);
        return response;
    }

    protected Request.Builder applyHeaders(IGClient client, Request.Builder req) {
        req.addHeader("Connection", "close");
        req.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        req.addHeader("Accept-Language", "en-US");
        req.addHeader("X-IG-Capabilities", client.getDevice().getCapabilities());
        req.addHeader("X-IG-App-ID", "567067343352427");
        req.addHeader("User-Agent", client.getDevice().getUserAgent());
        req.addHeader("X-IG-Connection-Type", "WIFI");
        req.addHeader("X-Ads-Opt-Out", "0");
        req.addHeader("X-CM-Bandwidth-KBPS", "-1.000");
        req.addHeader("X-CM-Latency", "-1.000");
        req.addHeader("X-IG-App-Locale", "en_US");
        req.addHeader("X-IG-Device-Locale", "en_US");
        req.addHeader("X-Pigeon-Session-Id", IGUtils.randomUuid());
        req.addHeader("X-Pigeon-Rawclienttime", System.currentTimeMillis() + "");
        req.addHeader("X-IG-Connection-Speed", ThreadLocalRandom.current().nextInt(2000, 4000) + "kbps");
        req.addHeader("X-IG-Bandwidth-Speed-KBPS", "-1.000");
        req.addHeader("X-IG-Bandwidth-TotalBytes-B", "0");
        req.addHeader("X-IG-Bandwidth-TotalTime-MS", "0");
        req.addHeader("X-IG-Extended-CDN-Thumbnail-Cache-Busting-Value", "1000");
        req.addHeader("X-IG-Device-ID", client.getGuid());
        req.addHeader("X-IG-Android-ID", client.getDeviceId());
        req.addHeader("X-FB-HTTP-engine", "Liger");
        Optional.ofNullable(client.getAuthorization()).ifPresent(s -> req.addHeader("Authorization", s));
        return req;
    }
}

