/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.requests;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.IGBaseModel;
import com.github.instagram4j.instagram4j.models.IGPayload;
import com.github.instagram4j.instagram4j.requests.IGRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IGPostRequest<T extends IGResponse>
extends IGRequest<T> {
    private static final Logger log = LoggerFactory.getLogger(IGPostRequest.class);

    protected abstract IGBaseModel getPayload(IGClient var1);

    protected boolean isSigned() {
        return true;
    }

    @Override
    public Request formRequest(IGClient client) {
        Request.Builder req = new Request.Builder().url(this.formUrl(client));
        this.applyHeaders(client, req);
        req.post(this.getRequestBody(client));
        return req.build();
    }

    protected RequestBody getRequestBody(IGClient client) {
        if (this.getPayload(client) == null) {
            return RequestBody.create((String)"", null);
        }
        String payload = IGUtils.objectToJson(this.getPayload(client) instanceof IGPayload ? client.setIGPayloadDefaults((IGPayload)this.getPayload(client)) : this.getPayload(client));
        log.debug("Payload : {}", (Object)payload);
        if (this.isSigned()) {
            return RequestBody.create((String)IGUtils.generateSignature(payload), (MediaType)MediaType.parse((String)"application/x-www-form-urlencoded; charset=UTF-8"));
        }
        return RequestBody.create((String)payload, (MediaType)MediaType.parse((String)"application/json; charset=UTF-8"));
    }
}

