/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.models.media.reel.item;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.instagram4j.instagram4j.models.media.reel.item.ReelMetadataItem;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StoryPollsItem
extends ReelMetadataItem {
    @NonNull
    private String question;
    @NonNull
    private List<Tally> tallies;
    public static final Tally YES = Tally.builder().text("YES").build();
    public static final Tally NO = Tally.builder().text("NO").build();

    @Override
    public String key() {
        return "story_polls";
    }

    private static List<Tally> $default$tallies() {
        return Arrays.asList(YES, NO);
    }

    protected StoryPollsItem(StoryPollsItemBuilder<?, ?> b) {
        super(b);
        this.question = ((StoryPollsItemBuilder)b).question;
        if (this.question == null) {
            throw new NullPointerException("question is marked non-null but is null");
        }
        this.tallies = ((StoryPollsItemBuilder)b).tallies$set ? ((StoryPollsItemBuilder)b).tallies$value : StoryPollsItem.$default$tallies();
        if (this.tallies == null) {
            throw new NullPointerException("tallies is marked non-null but is null");
        }
    }

    public static StoryPollsItemBuilder<?, ?> builder() {
        return new StoryPollsItemBuilderImpl();
    }

    @NonNull
    public String getQuestion() {
        return this.question;
    }

    @NonNull
    public List<Tally> getTallies() {
        return this.tallies;
    }

    public void setQuestion(@NonNull String question) {
        if (question == null) {
            throw new NullPointerException("question is marked non-null but is null");
        }
        this.question = question;
    }

    public void setTallies(@NonNull List<Tally> tallies) {
        if (tallies == null) {
            throw new NullPointerException("tallies is marked non-null but is null");
        }
        this.tallies = tallies;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoryPollsItem)) {
            return false;
        }
        StoryPollsItem other = (StoryPollsItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        List<Tally> this$tallies = this.getTallies();
        List<Tally> other$tallies = other.getTallies();
        return !(this$tallies == null ? other$tallies != null : !((Object)this$tallies).equals(other$tallies));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StoryPollsItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        List<Tally> $tallies = this.getTallies();
        result = result * 59 + ($tallies == null ? 43 : ((Object)$tallies).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "StoryPollsItem(super=" + super.toString() + ", question=" + this.getQuestion() + ", tallies=" + this.getTallies() + ")";
    }

    private static final class StoryPollsItemBuilderImpl
    extends StoryPollsItemBuilder<StoryPollsItem, StoryPollsItemBuilderImpl> {
        private StoryPollsItemBuilderImpl() {
        }

        @Override
        protected StoryPollsItemBuilderImpl self() {
            return this;
        }

        @Override
        public StoryPollsItem build() {
            return new StoryPollsItem(this);
        }
    }

    public static abstract class StoryPollsItemBuilder<C extends StoryPollsItem, B extends StoryPollsItemBuilder<C, B>>
    extends ReelMetadataItem.ReelMetadataItemBuilder<C, B> {
        private String question;
        private boolean tallies$set;
        private List<Tally> tallies$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B question(@NonNull String question) {
            if (question == null) {
                throw new NullPointerException("question is marked non-null but is null");
            }
            this.question = question;
            return (B)this.self();
        }

        public B tallies(@NonNull List<Tally> tallies) {
            if (tallies == null) {
                throw new NullPointerException("tallies is marked non-null but is null");
            }
            this.tallies$value = tallies;
            this.tallies$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "StoryPollsItem.StoryPollsItemBuilder(super=" + super.toString() + ", question=" + this.question + ", tallies$value=" + this.tallies$value + ")";
        }
    }

    public static class Tally {
        @NonNull
        private String text;
        private int count;
        private double font_size;

        private static int $default$count() {
            return 0;
        }

        private static double $default$font_size() {
            return 35.0;
        }

        Tally(@NonNull String text, int count, double font_size) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            this.count = count;
            this.font_size = font_size;
        }

        public static TallyBuilder builder() {
            return new TallyBuilder();
        }

        @NonNull
        public String getText() {
            return this.text;
        }

        public int getCount() {
            return this.count;
        }

        public double getFont_size() {
            return this.font_size;
        }

        public void setText(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setFont_size(double font_size) {
            this.font_size = font_size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tally)) {
                return false;
            }
            Tally other = (Tally)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            return Double.compare(this.getFont_size(), other.getFont_size()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tally;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            result = result * 59 + this.getCount();
            long $font_size = Double.doubleToLongBits(this.getFont_size());
            result = result * 59 + (int)($font_size >>> 32 ^ $font_size);
            return result;
        }

        public String toString() {
            return "StoryPollsItem.Tally(text=" + this.getText() + ", count=" + this.getCount() + ", font_size=" + this.getFont_size() + ")";
        }

        public static class TallyBuilder {
            private String text;
            private boolean count$set;
            private int count$value;
            private boolean font_size$set;
            private double font_size$value;

            TallyBuilder() {
            }

            public TallyBuilder text(@NonNull String text) {
                if (text == null) {
                    throw new NullPointerException("text is marked non-null but is null");
                }
                this.text = text;
                return this;
            }

            public TallyBuilder count(int count) {
                this.count$value = count;
                this.count$set = true;
                return this;
            }

            public TallyBuilder font_size(double font_size) {
                this.font_size$value = font_size;
                this.font_size$set = true;
                return this;
            }

            public Tally build() {
                int count$value = this.count$value;
                if (!this.count$set) {
                    count$value = Tally.$default$count();
                }
                double font_size$value = this.font_size$value;
                if (!this.font_size$set) {
                    font_size$value = Tally.$default$font_size();
                }
                return new Tally(this.text, count$value, font_size$value);
            }

            public String toString() {
                return "StoryPollsItem.Tally.TallyBuilder(text=" + this.text + ", count$value=" + this.count$value + ", font_size$value=" + this.font_size$value + ")";
            }
        }
    }
}

