/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.models.media;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import java.util.Arrays;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UploadParameters {
    private String retry_context;
    private String media_type;
    private Object[] xsharing_user_ids;
    private String image_compression;
    private String upload_id;
    private String is_sidecar;
    private String for_album;
    private String direct_v2;
    private String for_direct_story;
    private String is_igtv_video;
    private String is_direct_voice;

    public String toString() {
        return IGUtils.objectToJson(this);
    }

    public static UploadParameters forPhoto(String upload_id, String media_type, boolean is_sidecar) {
        return UploadParameters.builder().upload_id(upload_id).media_type(media_type).is_sidecar(is_sidecar ? "1" : null).image_compression("{\"lib_name\":\"moz\",\"lib_version\":\"3.1.m\",\"quality\":\"80\"}").build();
    }

    public static UploadParameters forTimelineVideo(String upload_id, boolean is_sidecar) {
        return UploadParameters.builder().upload_id(upload_id).media_type("2").is_sidecar(is_sidecar ? "1" : null).build();
    }

    public static UploadParameters forAlbumVideo(String upload_id) {
        return UploadParameters.builder().upload_id(upload_id).media_type("2").for_album("1").build();
    }

    public static UploadParameters forDirectVideo(String upload_id) {
        return UploadParameters.builder().upload_id(upload_id).media_type("2").direct_v2("1").build();
    }

    public static UploadParameters forDirectVoice(String upload_id) {
        return UploadParameters.builder().upload_id(upload_id).media_type("11").is_direct_voice("1").build();
    }

    public static UploadParameters forIgtv(String upload_id) {
        return UploadParameters.builder().upload_id(upload_id).is_igtv_video("1").build();
    }

    private static String $default$retry_context() {
        return "{\"num_step_auto_retry\":0,\"num_reupload\":0,\"num_step_manual_retry\":0}";
    }

    private static Object[] $default$xsharing_user_ids() {
        return new Object[0];
    }

    UploadParameters(String retry_context, String media_type, Object[] xsharing_user_ids, String image_compression, String upload_id, String is_sidecar, String for_album, String direct_v2, String for_direct_story, String is_igtv_video, String is_direct_voice) {
        this.retry_context = retry_context;
        this.media_type = media_type;
        this.xsharing_user_ids = xsharing_user_ids;
        this.image_compression = image_compression;
        this.upload_id = upload_id;
        this.is_sidecar = is_sidecar;
        this.for_album = for_album;
        this.direct_v2 = direct_v2;
        this.for_direct_story = for_direct_story;
        this.is_igtv_video = is_igtv_video;
        this.is_direct_voice = is_direct_voice;
    }

    public static UploadParametersBuilder builder() {
        return new UploadParametersBuilder();
    }

    public String getRetry_context() {
        return this.retry_context;
    }

    public String getMedia_type() {
        return this.media_type;
    }

    public Object[] getXsharing_user_ids() {
        return this.xsharing_user_ids;
    }

    public String getImage_compression() {
        return this.image_compression;
    }

    public String getUpload_id() {
        return this.upload_id;
    }

    public String getIs_sidecar() {
        return this.is_sidecar;
    }

    public String getFor_album() {
        return this.for_album;
    }

    public String getDirect_v2() {
        return this.direct_v2;
    }

    public String getFor_direct_story() {
        return this.for_direct_story;
    }

    public String getIs_igtv_video() {
        return this.is_igtv_video;
    }

    public String getIs_direct_voice() {
        return this.is_direct_voice;
    }

    public void setRetry_context(String retry_context) {
        this.retry_context = retry_context;
    }

    public void setMedia_type(String media_type) {
        this.media_type = media_type;
    }

    public void setXsharing_user_ids(Object[] xsharing_user_ids) {
        this.xsharing_user_ids = xsharing_user_ids;
    }

    public void setImage_compression(String image_compression) {
        this.image_compression = image_compression;
    }

    public void setUpload_id(String upload_id) {
        this.upload_id = upload_id;
    }

    public void setIs_sidecar(String is_sidecar) {
        this.is_sidecar = is_sidecar;
    }

    public void setFor_album(String for_album) {
        this.for_album = for_album;
    }

    public void setDirect_v2(String direct_v2) {
        this.direct_v2 = direct_v2;
    }

    public void setFor_direct_story(String for_direct_story) {
        this.for_direct_story = for_direct_story;
    }

    public void setIs_igtv_video(String is_igtv_video) {
        this.is_igtv_video = is_igtv_video;
    }

    public void setIs_direct_voice(String is_direct_voice) {
        this.is_direct_voice = is_direct_voice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadParameters)) {
            return false;
        }
        UploadParameters other = (UploadParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$retry_context = this.getRetry_context();
        String other$retry_context = other.getRetry_context();
        if (this$retry_context == null ? other$retry_context != null : !this$retry_context.equals(other$retry_context)) {
            return false;
        }
        String this$media_type = this.getMedia_type();
        String other$media_type = other.getMedia_type();
        if (this$media_type == null ? other$media_type != null : !this$media_type.equals(other$media_type)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getXsharing_user_ids(), other.getXsharing_user_ids())) {
            return false;
        }
        String this$image_compression = this.getImage_compression();
        String other$image_compression = other.getImage_compression();
        if (this$image_compression == null ? other$image_compression != null : !this$image_compression.equals(other$image_compression)) {
            return false;
        }
        String this$upload_id = this.getUpload_id();
        String other$upload_id = other.getUpload_id();
        if (this$upload_id == null ? other$upload_id != null : !this$upload_id.equals(other$upload_id)) {
            return false;
        }
        String this$is_sidecar = this.getIs_sidecar();
        String other$is_sidecar = other.getIs_sidecar();
        if (this$is_sidecar == null ? other$is_sidecar != null : !this$is_sidecar.equals(other$is_sidecar)) {
            return false;
        }
        String this$for_album = this.getFor_album();
        String other$for_album = other.getFor_album();
        if (this$for_album == null ? other$for_album != null : !this$for_album.equals(other$for_album)) {
            return false;
        }
        String this$direct_v2 = this.getDirect_v2();
        String other$direct_v2 = other.getDirect_v2();
        if (this$direct_v2 == null ? other$direct_v2 != null : !this$direct_v2.equals(other$direct_v2)) {
            return false;
        }
        String this$for_direct_story = this.getFor_direct_story();
        String other$for_direct_story = other.getFor_direct_story();
        if (this$for_direct_story == null ? other$for_direct_story != null : !this$for_direct_story.equals(other$for_direct_story)) {
            return false;
        }
        String this$is_igtv_video = this.getIs_igtv_video();
        String other$is_igtv_video = other.getIs_igtv_video();
        if (this$is_igtv_video == null ? other$is_igtv_video != null : !this$is_igtv_video.equals(other$is_igtv_video)) {
            return false;
        }
        String this$is_direct_voice = this.getIs_direct_voice();
        String other$is_direct_voice = other.getIs_direct_voice();
        return !(this$is_direct_voice == null ? other$is_direct_voice != null : !this$is_direct_voice.equals(other$is_direct_voice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $retry_context = this.getRetry_context();
        result = result * 59 + ($retry_context == null ? 43 : $retry_context.hashCode());
        String $media_type = this.getMedia_type();
        result = result * 59 + ($media_type == null ? 43 : $media_type.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getXsharing_user_ids());
        String $image_compression = this.getImage_compression();
        result = result * 59 + ($image_compression == null ? 43 : $image_compression.hashCode());
        String $upload_id = this.getUpload_id();
        result = result * 59 + ($upload_id == null ? 43 : $upload_id.hashCode());
        String $is_sidecar = this.getIs_sidecar();
        result = result * 59 + ($is_sidecar == null ? 43 : $is_sidecar.hashCode());
        String $for_album = this.getFor_album();
        result = result * 59 + ($for_album == null ? 43 : $for_album.hashCode());
        String $direct_v2 = this.getDirect_v2();
        result = result * 59 + ($direct_v2 == null ? 43 : $direct_v2.hashCode());
        String $for_direct_story = this.getFor_direct_story();
        result = result * 59 + ($for_direct_story == null ? 43 : $for_direct_story.hashCode());
        String $is_igtv_video = this.getIs_igtv_video();
        result = result * 59 + ($is_igtv_video == null ? 43 : $is_igtv_video.hashCode());
        String $is_direct_voice = this.getIs_direct_voice();
        result = result * 59 + ($is_direct_voice == null ? 43 : $is_direct_voice.hashCode());
        return result;
    }

    public static class UploadParametersBuilder {
        private boolean retry_context$set;
        private String retry_context$value;
        private String media_type;
        private boolean xsharing_user_ids$set;
        private Object[] xsharing_user_ids$value;
        private String image_compression;
        private String upload_id;
        private String is_sidecar;
        private String for_album;
        private String direct_v2;
        private String for_direct_story;
        private String is_igtv_video;
        private String is_direct_voice;

        UploadParametersBuilder() {
        }

        public UploadParametersBuilder retry_context(String retry_context) {
            this.retry_context$value = retry_context;
            this.retry_context$set = true;
            return this;
        }

        public UploadParametersBuilder media_type(String media_type) {
            this.media_type = media_type;
            return this;
        }

        public UploadParametersBuilder xsharing_user_ids(Object[] xsharing_user_ids) {
            this.xsharing_user_ids$value = xsharing_user_ids;
            this.xsharing_user_ids$set = true;
            return this;
        }

        public UploadParametersBuilder image_compression(String image_compression) {
            this.image_compression = image_compression;
            return this;
        }

        public UploadParametersBuilder upload_id(String upload_id) {
            this.upload_id = upload_id;
            return this;
        }

        public UploadParametersBuilder is_sidecar(String is_sidecar) {
            this.is_sidecar = is_sidecar;
            return this;
        }

        public UploadParametersBuilder for_album(String for_album) {
            this.for_album = for_album;
            return this;
        }

        public UploadParametersBuilder direct_v2(String direct_v2) {
            this.direct_v2 = direct_v2;
            return this;
        }

        public UploadParametersBuilder for_direct_story(String for_direct_story) {
            this.for_direct_story = for_direct_story;
            return this;
        }

        public UploadParametersBuilder is_igtv_video(String is_igtv_video) {
            this.is_igtv_video = is_igtv_video;
            return this;
        }

        public UploadParametersBuilder is_direct_voice(String is_direct_voice) {
            this.is_direct_voice = is_direct_voice;
            return this;
        }

        public UploadParameters build() {
            String retry_context$value = this.retry_context$value;
            if (!this.retry_context$set) {
                retry_context$value = UploadParameters.$default$retry_context();
            }
            Object[] xsharing_user_ids$value = this.xsharing_user_ids$value;
            if (!this.xsharing_user_ids$set) {
                xsharing_user_ids$value = UploadParameters.$default$xsharing_user_ids();
            }
            return new UploadParameters(retry_context$value, this.media_type, xsharing_user_ids$value, this.image_compression, this.upload_id, this.is_sidecar, this.for_album, this.direct_v2, this.for_direct_story, this.is_igtv_video, this.is_direct_voice);
        }

        public String toString() {
            return "UploadParameters.UploadParametersBuilder(retry_context$value=" + this.retry_context$value + ", media_type=" + this.media_type + ", xsharing_user_ids$value=" + Arrays.deepToString(this.xsharing_user_ids$value) + ", image_compression=" + this.image_compression + ", upload_id=" + this.upload_id + ", is_sidecar=" + this.is_sidecar + ", for_album=" + this.for_album + ", direct_v2=" + this.direct_v2 + ", for_direct_story=" + this.for_direct_story + ", is_igtv_video=" + this.is_igtv_video + ", is_direct_voice=" + this.is_direct_voice + ")";
        }
    }
}

