/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.models.discover;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.github.instagram4j.instagram4j.models.discover.SectionalItem;
import com.github.instagram4j.instagram4j.models.media.timeline.TimelineMedia;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonTypeName(value="media_grid")
public class SectionalMediaGridItem
extends SectionalItem {
    @JsonProperty(value="layout_content")
    @JsonDeserialize(converter=LayoutContentToIGTimelineMedia.class)
    private List<TimelineMedia> medias;

    public List<TimelineMedia> getMedias() {
        return this.medias;
    }

    @JsonProperty(value="layout_content")
    public void setMedias(List<TimelineMedia> medias) {
        this.medias = medias;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SectionalMediaGridItem)) {
            return false;
        }
        SectionalMediaGridItem other = (SectionalMediaGridItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<TimelineMedia> this$medias = this.getMedias();
        List<TimelineMedia> other$medias = other.getMedias();
        return !(this$medias == null ? other$medias != null : !((Object)this$medias).equals(other$medias));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SectionalMediaGridItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TimelineMedia> $medias = this.getMedias();
        result = result * 59 + ($medias == null ? 43 : ((Object)$medias).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SectionalMediaGridItem(super=" + super.toString() + ", medias=" + this.getMedias() + ")";
    }

    private static class LayoutContentToIGTimelineMedia
    extends StdConverter<Map<String, List<Map<String, Object>>>, List<TimelineMedia>> {
        private LayoutContentToIGTimelineMedia() {
        }

        public List<TimelineMedia> convert(Map<String, List<Map<String, Object>>> value) {
            return value.get("medias").stream().map(m -> IGUtils.convertToView(m.get("media"), TimelineMedia.class)).collect(Collectors.toList());
        }
    }
}

