/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.exceptions;

import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import java.io.IOException;
import lombok.NonNull;

public class IGResponseException
extends IOException {
    @NonNull
    private IGResponse response;

    public IGResponseException(IGResponse response) {
        super(response.getMessage());
        this.response = response;
    }

    @NonNull
    public IGResponse getResponse() {
        return this.response;
    }

    public static class IGFailedResponse
    extends IGResponse {
        private String status = "fail";
        private final String message;

        public static IGResponse of(Throwable throwable) {
            if (throwable instanceof IGResponseException) {
                return ((IGResponseException)throwable).getResponse();
            }
            return new IGFailedResponse(throwable.toString());
        }

        public static <T> T of(Throwable throwable, Class<T> clazz) {
            return IGUtils.convertToView((Object)IGFailedResponse.of(throwable), clazz);
        }

        public IGFailedResponse(String message) {
            this.message = message;
        }

        @Override
        public String getStatus() {
            return this.status;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public void setStatus(String status) {
            this.status = status;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IGFailedResponse)) {
                return false;
            }
            IGFailedResponse other = (IGFailedResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof IGFailedResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "IGResponseException.IGFailedResponse(super=" + super.toString() + ", status=" + this.getStatus() + ", message=" + this.getMessage() + ")";
        }
    }
}

