/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.actions.users;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.actions.users.UserAction;
import com.github.instagram4j.instagram4j.models.user.User;
import com.github.instagram4j.instagram4j.requests.users.UsersInfoRequest;
import com.github.instagram4j.instagram4j.requests.users.UsersSearchRequest;
import com.github.instagram4j.instagram4j.requests.users.UsersUsernameInfoRequest;
import com.github.instagram4j.instagram4j.responses.users.UserResponse;
import com.github.instagram4j.instagram4j.responses.users.UsersSearchResponse;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public class UsersAction {
    @NonNull
    private IGClient client;

    public CompletableFuture<UserAction> findByUsername(String username) {
        return new UsersUsernameInfoRequest(username).execute(this.client).thenApply(response -> new UserAction(this.client, response.getUser()));
    }

    public CompletableFuture<User> info(long pk) {
        return new UsersInfoRequest(pk).execute(this.client).thenApply(UserResponse::getUser);
    }

    public CompletableFuture<UsersSearchResponse> search(String query) {
        return new UsersSearchRequest(query).execute(this.client);
    }

    public UsersAction(@NonNull IGClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }
}

