/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.actions.users;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.actions.feed.FeedIterable;
import com.github.instagram4j.instagram4j.models.friendships.Friendship;
import com.github.instagram4j.instagram4j.models.user.User;
import com.github.instagram4j.instagram4j.requests.friendships.FriendshipsActionRequest;
import com.github.instagram4j.instagram4j.requests.friendships.FriendshipsFeedsRequest;
import com.github.instagram4j.instagram4j.requests.friendships.FriendshipsShowRequest;
import com.github.instagram4j.instagram4j.responses.feed.FeedUsersResponse;
import com.github.instagram4j.instagram4j.responses.friendships.FriendshipStatusResponse;
import com.github.instagram4j.instagram4j.responses.friendships.FriendshipsShowResponse;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public class UserAction {
    @NonNull
    private IGClient client;
    @NonNull
    private User user;

    public FeedIterable<FriendshipsFeedsRequest, FeedUsersResponse> followersFeed() {
        return new FeedIterable<FriendshipsFeedsRequest, FeedUsersResponse>(this.client, () -> new FriendshipsFeedsRequest(this.user.getPk(), FriendshipsFeedsRequest.FriendshipsFeeds.FOLLOWERS));
    }

    public FeedIterable<FriendshipsFeedsRequest, FeedUsersResponse> followingFeed() {
        return new FeedIterable<FriendshipsFeedsRequest, FeedUsersResponse>(this.client, () -> new FriendshipsFeedsRequest(this.user.getPk(), FriendshipsFeedsRequest.FriendshipsFeeds.FOLLOWING));
    }

    public CompletableFuture<Friendship> getFriendship() {
        return new FriendshipsShowRequest(this.user.getPk()).execute(this.client).thenApply(FriendshipsShowResponse::getFriendship);
    }

    public CompletableFuture<FriendshipStatusResponse> action(FriendshipsActionRequest.FriendshipsAction action) {
        return new FriendshipsActionRequest(this.user.getPk(), action).execute(this.client);
    }

    public UserAction(@NonNull IGClient client, @NonNull User user) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.client = client;
        this.user = user;
    }

    @NonNull
    public User getUser() {
        return this.user;
    }
}

