/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.actions.upload;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.models.media.UploadParameters;
import com.github.instagram4j.instagram4j.requests.upload.MediaUploadFinishRequest;
import com.github.instagram4j.instagram4j.requests.upload.RuploadPhotoRequest;
import com.github.instagram4j.instagram4j.requests.upload.RuploadSegmentVideoGetRequest;
import com.github.instagram4j.instagram4j.requests.upload.RuploadSegmentVideoPhaseRequest;
import com.github.instagram4j.instagram4j.requests.upload.RuploadVideoRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.responses.media.RuploadPhotoResponse;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadAction {
    private static final Logger log = LoggerFactory.getLogger(UploadAction.class);
    @NonNull
    private IGClient client;

    public CompletableFuture<RuploadPhotoResponse> photo(byte[] data, String upload_id, boolean is_sidecar) {
        return new RuploadPhotoRequest(data, "1", upload_id, is_sidecar).execute(this.client);
    }

    public CompletableFuture<RuploadPhotoResponse> photo(byte[] data, String upload_id) {
        return this.photo(data, upload_id, false);
    }

    public CompletableFuture<? extends IGResponse> videoWithCover(byte[] data, byte[] cover, UploadParameters parameters) {
        return new RuploadVideoRequest(data, parameters).execute(this.client).thenCompose(response -> this.photo(cover, parameters.getUpload_id()));
    }

    public CompletableFuture<? extends IGResponse> chunkedVideoWithCover(byte[] data, byte[] cover, int chunk_size, String upload_id) {
        return this.segments(upload_id, UploadAction.toSegments(data, chunk_size), data.length).thenCompose(response -> this.photo(cover, upload_id));
    }

    public CompletableFuture<IGResponse> finish(String upload_id) {
        return new MediaUploadFinishRequest(upload_id).execute(this.client);
    }

    public CompletableFuture<IGResponse> segments(String upload_id, byte[][] segments, int totalLengthBytes) {
        String transfer_id = upload_id;
        UploadParameters parameter = UploadParameters.forIgtv(upload_id);
        return new RuploadSegmentVideoPhaseRequest(RuploadSegmentVideoPhaseRequest.Phase.START, parameter).execute(this.client).thenCompose(startResponse -> {
            String stream_id = startResponse.get("stream_id").toString();
            CompletionStage<IGResponse> uploadResponse = CompletableFuture.completedFuture(startResponse);
            int i = 0;
            do {
                int segment = i++;
                String offset = String.valueOf(segment * segments[0].length);
                uploadResponse = ((CompletableFuture)((CompletableFuture)uploadResponse).thenCompose(res -> new RuploadSegmentVideoGetRequest(parameter, stream_id, transfer_id, offset).execute(this.client))).thenCompose(res -> {
                    log.info("{} Uploading segment ({}/{})", new Object[]{upload_id, segment + 1, segments.length});
                    return new RuploadSegmentVideoPhaseRequest(RuploadSegmentVideoPhaseRequest.Phase.TRANSFER, parameter, stream_id, transfer_id, offset, String.valueOf(totalLengthBytes), segments[segment]).execute(this.client).whenComplete((transRes, tr) -> log.info("{} Done uploading segment {}", (Object)upload_id, (Object)(segment + 1)));
                });
            } while (i < segments.length);
            return ((CompletableFuture)uploadResponse).thenCompose(res -> new RuploadSegmentVideoPhaseRequest(RuploadSegmentVideoPhaseRequest.Phase.END, parameter, stream_id, transfer_id).execute(this.client));
        });
    }

    public static byte[][] toSegments(byte[] data, int segmentSize) {
        int remainder = data.length % segmentSize;
        int segments = data.length / segmentSize + (remainder == 0 ? 0 : 1);
        byte[][] ans = new byte[segments][];
        for (int i = 0; i < (remainder == 0 ? segments : segments - 1); ++i) {
            ans[i] = Arrays.copyOfRange(data, i * segmentSize, i * segmentSize + segmentSize);
        }
        if (remainder != 0) {
            ans[ans.length - 1] = Arrays.copyOfRange(data, (ans.length - 1) * segmentSize, (ans.length - 1) * segmentSize + remainder);
        }
        return ans;
    }

    public UploadAction(@NonNull IGClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }
}

