/*
 * Decompiled with CFR 0.152.
 */
package com.github.instagram4j.instagram4j.actions.timeline;

import com.github.instagram4j.instagram4j.IGClient;
import com.github.instagram4j.instagram4j.actions.feed.FeedIterable;
import com.github.instagram4j.instagram4j.actions.media.MediaAction;
import com.github.instagram4j.instagram4j.models.media.UploadParameters;
import com.github.instagram4j.instagram4j.requests.feed.FeedTimelineRequest;
import com.github.instagram4j.instagram4j.requests.media.MediaConfigureSidecarRequest;
import com.github.instagram4j.instagram4j.requests.media.MediaConfigureTimelineRequest;
import com.github.instagram4j.instagram4j.responses.IGResponse;
import com.github.instagram4j.instagram4j.responses.feed.FeedTimelineResponse;
import com.github.instagram4j.instagram4j.responses.media.MediaResponse;
import com.github.instagram4j.instagram4j.responses.media.RuploadPhotoResponse;
import com.github.instagram4j.instagram4j.utils.IGUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.NonNull;

public class TimelineAction {
    @NonNull
    private final IGClient client;

    public FeedIterable<FeedTimelineRequest, FeedTimelineResponse> feed() {
        return new FeedIterable<FeedTimelineRequest, FeedTimelineResponse>(this.client, FeedTimelineRequest::new);
    }

    public CompletableFuture<MediaResponse.MediaConfigureTimelineResponse> uploadPhoto(byte[] data, MediaConfigureTimelineRequest.MediaConfigurePayload payload) {
        return this.client.actions().upload().photo(data, String.valueOf(System.currentTimeMillis())).thenCompose(res -> MediaAction.configureMediaToTimeline(this.client, res.getUpload_id(), payload));
    }

    public CompletableFuture<MediaResponse.MediaConfigureTimelineResponse> uploadPhoto(byte[] data, String caption) {
        return this.uploadPhoto(data, new MediaConfigureTimelineRequest.MediaConfigurePayload().caption(caption));
    }

    public CompletableFuture<MediaResponse.MediaConfigureTimelineResponse> uploadPhoto(File file, String caption) {
        return this.uploadPhoto(file, new MediaConfigureTimelineRequest.MediaConfigurePayload().caption(caption));
    }

    public CompletableFuture<MediaResponse.MediaConfigureTimelineResponse> uploadPhoto(File file, MediaConfigureTimelineRequest.MediaConfigurePayload payload) {
        try {
            return this.uploadPhoto(Files.readAllBytes(file.toPath()), payload);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    public CompletableFuture<MediaResponse.MediaConfigureTimelineResponse> uploadVideo(byte[] videoData, byte[] coverData, MediaConfigureTimelineRequest.MediaConfigurePayload payload) {
        return this.uploadVideoWithTimeout(videoData, coverData, payload, 0L);
    }

    public CompletableFuture<MediaResponse.MediaConfigureTimelineResponse> uploadVideo(File video, File cover, String caption) {
        return this.uploadVideo(video, cover, new MediaConfigureTimelineRequest.MediaConfigurePayload().caption(caption));
    }

    public CompletableFuture<MediaResponse.MediaConfigureTimelineResponse> uploadVideo(File video, File cover, MediaConfigureTimelineRequest.MediaConfigurePayload payload) {
        try {
            return this.uploadVideo(Files.readAllBytes(video.toPath()), Files.readAllBytes(cover.toPath()), payload);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    public CompletableFuture<MediaResponse.MediaConfigureTimelineResponse> uploadVideoWithTimeout(byte[] videoData, byte[] coverData, MediaConfigureTimelineRequest.MediaConfigurePayload payload, long uploadFinishTimeoutSeconds) {
        String upload_id = String.valueOf(System.currentTimeMillis());
        return ((CompletableFuture)this.client.actions().upload().videoWithCover(videoData, coverData, UploadParameters.forTimelineVideo(upload_id, false)).thenCompose(response -> {
            IGUtils.sleepSeconds(uploadFinishTimeoutSeconds);
            return this.client.actions().upload().finish(upload_id);
        })).thenCompose(response -> MediaAction.configureMediaToTimeline(this.client, upload_id, payload));
    }

    public CompletableFuture<MediaResponse.MediaConfigureTimelineResponse> uploadVideo(byte[] videoData, byte[] coverData, String caption) {
        return this.uploadVideo(videoData, coverData, new MediaConfigureTimelineRequest.MediaConfigurePayload().caption(caption));
    }

    public CompletableFuture<MediaResponse.MediaConfigureSidecarResponse> uploadAlbum(List<SidecarInfo> infos, MediaConfigureSidecarRequest.MediaConfigureSidecarPayload payload) {
        List<CompletableFuture> uploadFutures = infos.stream().map(s -> s.upload(this.client)).collect(Collectors.toList());
        payload.children_metadata().addAll(infos.stream().map(SidecarInfo::metadata).collect(Collectors.toList()));
        return CompletableFuture.allOf(uploadFutures.toArray(new CompletableFuture[uploadFutures.size()])).thenCompose(res -> MediaAction.configureAlbumToTimeline(this.client, payload));
    }

    public CompletableFuture<MediaResponse.MediaConfigureSidecarResponse> uploadAlbum(List<SidecarInfo> infos, String caption) {
        return this.uploadAlbum(infos, new MediaConfigureSidecarRequest.MediaConfigureSidecarPayload().caption(caption));
    }

    public TimelineAction(@NonNull IGClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }

    public static class SidecarVideo
    implements SidecarInfo {
        @NonNull
        private byte[] data;
        @NonNull
        private byte[] cover_data;
        private MediaConfigureSidecarRequest.SidecarChildrenMetadata metadata = new MediaConfigureSidecarRequest.SidecarChildrenMetadata(String.valueOf(System.currentTimeMillis()));

        @Override
        public CompletableFuture<? extends IGResponse> upload(IGClient client) {
            return client.actions().upload().videoWithCover(this.data, this.cover_data, UploadParameters.forTimelineVideo(this.metadata.upload_id(), true));
        }

        public static SidecarVideo from(File video, File cover) {
            try {
                return new SidecarVideo(Files.readAllBytes(video.toPath()), Files.readAllBytes(cover.toPath()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public static SidecarVideo from(File video, File cover, MediaConfigureSidecarRequest.SidecarChildrenMetadata metadata) {
            try {
                return new SidecarVideo(Files.readAllBytes(video.toPath()), Files.readAllBytes(cover.toPath())).metadata(metadata);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public SidecarVideo(@NonNull byte[] data, @NonNull byte[] cover_data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            if (cover_data == null) {
                throw new NullPointerException("cover_data is marked non-null but is null");
            }
            this.data = data;
            this.cover_data = cover_data;
        }

        @NonNull
        public byte[] data() {
            return this.data;
        }

        @NonNull
        public byte[] cover_data() {
            return this.cover_data;
        }

        @Override
        public MediaConfigureSidecarRequest.SidecarChildrenMetadata metadata() {
            return this.metadata;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SidecarVideo)) {
                return false;
            }
            SidecarVideo other = (SidecarVideo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.data(), other.data())) {
                return false;
            }
            if (!Arrays.equals(this.cover_data(), other.cover_data())) {
                return false;
            }
            MediaConfigureSidecarRequest.SidecarChildrenMetadata this$metadata = this.metadata();
            MediaConfigureSidecarRequest.SidecarChildrenMetadata other$metadata = other.metadata();
            return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SidecarVideo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.data());
            result = result * 59 + Arrays.hashCode(this.cover_data());
            MediaConfigureSidecarRequest.SidecarChildrenMetadata $metadata = this.metadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            return result;
        }

        public String toString() {
            return "TimelineAction.SidecarVideo(data=" + Arrays.toString(this.data()) + ", cover_data=" + Arrays.toString(this.cover_data()) + ", metadata=" + this.metadata() + ")";
        }

        public SidecarVideo data(@NonNull byte[] data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        public SidecarVideo cover_data(@NonNull byte[] cover_data) {
            if (cover_data == null) {
                throw new NullPointerException("cover_data is marked non-null but is null");
            }
            this.cover_data = cover_data;
            return this;
        }

        public SidecarVideo metadata(MediaConfigureSidecarRequest.SidecarChildrenMetadata metadata) {
            this.metadata = metadata;
            return this;
        }
    }

    public static class SidecarPhoto
    implements SidecarInfo {
        @NonNull
        private byte[] data;
        private MediaConfigureSidecarRequest.SidecarChildrenMetadata metadata = new MediaConfigureSidecarRequest.SidecarChildrenMetadata(String.valueOf(System.currentTimeMillis()));

        public CompletableFuture<RuploadPhotoResponse> upload(IGClient client) {
            return client.actions().upload().photo(this.data, this.metadata.upload_id(), true);
        }

        public static SidecarPhoto from(File file) {
            try {
                return new SidecarPhoto(Files.readAllBytes(file.toPath()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public static SidecarPhoto from(File file, MediaConfigureSidecarRequest.SidecarChildrenMetadata metadata) {
            try {
                return new SidecarPhoto(Files.readAllBytes(file.toPath())).metadata(metadata);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public SidecarPhoto(@NonNull byte[] data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
        }

        @NonNull
        public byte[] data() {
            return this.data;
        }

        @Override
        public MediaConfigureSidecarRequest.SidecarChildrenMetadata metadata() {
            return this.metadata;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SidecarPhoto)) {
                return false;
            }
            SidecarPhoto other = (SidecarPhoto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.data(), other.data())) {
                return false;
            }
            MediaConfigureSidecarRequest.SidecarChildrenMetadata this$metadata = this.metadata();
            MediaConfigureSidecarRequest.SidecarChildrenMetadata other$metadata = other.metadata();
            return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SidecarPhoto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.data());
            MediaConfigureSidecarRequest.SidecarChildrenMetadata $metadata = this.metadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            return result;
        }

        public String toString() {
            return "TimelineAction.SidecarPhoto(data=" + Arrays.toString(this.data()) + ", metadata=" + this.metadata() + ")";
        }

        public SidecarPhoto data(@NonNull byte[] data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        public SidecarPhoto metadata(MediaConfigureSidecarRequest.SidecarChildrenMetadata metadata) {
            this.metadata = metadata;
            return this;
        }
    }

    public static interface SidecarInfo {
        public CompletableFuture<? extends IGResponse> upload(IGClient var1);

        public MediaConfigureSidecarRequest.SidecarChildrenMetadata metadata();
    }
}

